<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WhsReport extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'title',
        'number',
        'authorised_by',
        'project_id',
        'conducted_by',
        'conducted_by_position',
        'priority',
        'project_title',
        'project_number',
        'revision_date',
        'created_by',
        'swms_name',
        'swms_number',
        'swms_rev_number',
        'document_title',
        'document_number',
        'authorised_by',
        'position',
        'revision_number',
        'site_supervisor',
        'forman',
        'leading_hand',
        'safty_officer',
        'principle_contractor',
        'other_contractor',
        'level_of_action',
        'location',
        'activities',
        'notes',
        'general_notes',
        'inspection_date',
        'issue_date',
        'start_time',
        'end_time',
        'date',
        'swms_id',
        'swms_number',
        'swms_rev',
        'additional_attending_inspections_id',
        'activities',
        'status',
        'is_published',
        'customer_id',
        'workspace_id',
        'site_id',
        'report_method',
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];
    
    public function authorizedBy()
    {
        return $this->belongsTo(EmpPersonalDetails::class, 'authorised_by', 'emp_id');
    }

    public function siteData()
    {
        return $this->belongsTo(Sites::class, 'site_id', 'id');
    }
}
