<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class XeroPayslipHistory extends BaseModel
{
    use HasFactory;

    protected $table = 'xero_payslip_history';

    protected $fillable = [
        'customer_id',
        'workspace_id',
        'employee_id',
        'emp_type',
        'subcontractor_id',
        'xero_emp_id',
        'start_date',
        'end_date',
        'hours',
        'status',
        'xero_response',
        'xero_timesheet_id',
    ];

    protected $casts = [
        'start_date' => 'date',
        'end_date' => 'date',
        'hours' => 'decimal:2',
        'xero_response' => 'array',
    ];

    /**
     * Relationship with internal employee
     */
    public function employee()
    {
        return $this->belongsTo(EmpCompanyDetails::class, 'employee_id', 'id');
    }

    /**
     * Relationship with subcontractor employee (external)
     */
    public function subcontractorEmployee()
    {
        return $this->belongsTo(EmployeeSubcontractor::class, 'employee_id', 'id');
    }

    /**
     * Relationship with subcontractor
     */
    public function subcontractor()
    {
        return $this->belongsTo(User::class, 'subcontractor_id', 'id');
    }
}
