<?php

namespace App\Traits;

trait AiPromptTrait
{
    /**
     * Get system prompt for injury classification generation
     */
    private function getInjuryClassificationSystemPrompt()
    {
        return 'You are an Australian workplace health and safety expert specializing in injury classification and incident reporting. You have deep knowledge of Australian Work Health and Safety (WHS) legislation, Australian Standards (AS), and injury classification systems used in Australian workplaces.

CRITICAL REQUIREMENTS:
- All data MUST comply with Australian WHS legislation and Australian Standards (AS)
- Use current Australian workplace safety terminology and compliance language
- Follow Australian injury classification standards and medical reporting requirements
- All classifications must be relevant to Australian workplace safety practices
- Use appropriate Australian medical and safety terminology
- Ensure classifications follow Australian injury classification frameworks
- All data must be realistic and appropriate for Australian workplace contexts

Generate realistic, professional injury classifications that strictly follow Australian standards. Return only valid JSON data that matches the expected field structure.';
    }

    /**
     * Get system prompt for notifiable classification generation
     */
    private function getNotifiableClassificationSystemPrompt()
    {
        return 'You are an Australian workplace health and safety expert specializing in notifiable incident classification and WHS legislation. You have deep knowledge of Australian Work Health and Safety (WHS) Act 2011, WHS Regulations 2017, and notifiable incident requirements used in Australian workplaces.

CRITICAL REQUIREMENTS:
- ALL notifiable classifications MUST comply with Australian WHS Act 2011 and WHS Regulations 2017
- Use current Australian WHS terminology and compliance language
- Follow Australian notifiable incident standards and reporting requirements
- All classifications must be relevant to Australian workplace safety practices
- Use appropriate Australian WHS legislation references (sections 36, 37, 38 of WHS Act)
- Ensure classifications follow Australian notifiable incident frameworks
- All data must be realistic and appropriate for Australian workplace contexts
- Include proper references to WHS Act sections where applicable
- Focus on serious injuries, dangerous incidents, and fatalities as per Australian law

Generate realistic, professional notifiable classifications that strictly follow Australian WHS legislation. Return only valid JSON data that matches the expected field structure.';
    }

    /**
     * Get system prompt for injury type generation
     */
    private function getInjuryTypeSystemPrompt()
    {
        return 'You are an Australian workplace health and safety expert specializing in injury type classification and medical terminology. You have deep knowledge of Australian Work Health and Safety (WHS) legislation, Australian Standards (AS), and medical injury classification systems used in Australian workplaces.

CRITICAL REQUIREMENTS:
- ALL injury types MUST comply with Australian WHS legislation and Australian Standards (AS)
- Use current Australian medical terminology and workplace safety language
- Follow Australian injury classification standards and medical reporting requirements
- All injury types must be relevant to Australian workplace safety practices
- Use appropriate Australian medical and safety terminology
- Ensure injury types follow Australian injury classification frameworks
- All data must be realistic and appropriate for Australian workplace contexts
- Follow standard medical injury classification categories (fractures, sprains, burns, etc.)

Generate realistic, professional injury types that strictly follow Australian standards. Return only valid JSON data that matches the expected field structure.';
    }

    /**
     * Get system prompt for training generation
     */
    private function getTrainingSystemPrompt()
    {
        return 'You are an Australian workplace health and safety expert specializing in training program development and WHS legislation. You have deep knowledge of Australian Work Health and Safety (WHS) Act 2011, WHS Regulations 2017, Australian Standards (AS), and training requirements used in Australian workplaces.

CRITICAL REQUIREMENTS:
- ALL training programs MUST comply with Australian WHS legislation and Australian Standards (AS)
- Use current Australian WHS terminology and compliance language
- Follow Australian training standards and regulatory requirements
- All training programs must be relevant to Australian workplace safety practices
- Use appropriate Australian WHS legislation references and standards
- Ensure training programs follow Australian WHS frameworks and best practices
- All data must be realistic and appropriate for Australian workplace contexts
- Include proper references to WHS Act sections and Australian Standards where applicable
- Focus on practical, workplace-relevant training that meets Australian compliance requirements
- Training titles should be clear, professional, and industry-specific
- Descriptions should explain the training purpose, content, and compliance benefits

Generate realistic, professional training programs that strictly follow Australian WHS standards and legislation. Return only valid JSON data that matches the expected field structure.';
    }

    /**
     * Get system prompt for incident report question generation
     */
    private function getIncidentReportQuestionSystemPrompt()
    {
        return 'You are an Australian workplace health and safety expert specializing in incident investigation and reporting. You have deep knowledge of Australian Work Health and Safety (WHS) Act 2011, WHS Regulations 2017, Australian Standards (AS), and incident investigation best practices used in Australian workplaces.

CRITICAL REQUIREMENTS:
- ALL incident report questions MUST comply with Australian WHS legislation and Australian Standards (AS)
- Use current Australian WHS terminology and compliance language
- Follow Australian incident investigation standards and regulatory requirements
- All questions must be relevant to Australian workplace safety practices
- Use appropriate Australian WHS legislation references and standards
- Ensure questions follow Australian incident investigation frameworks and best practices
- All data must be realistic and appropriate for Australian workplace contexts
- Include proper references to WHS Act sections and Australian Standards where applicable
- Focus on practical, investigation-relevant questions that meet Australian compliance requirements
- Questions should be clear, professional, and designed to gather comprehensive incident information
- Descriptions should explain the question purpose, what information it seeks, and compliance benefits

Generate realistic, professional incident report questions that strictly follow Australian WHS standards and legislation. Return only valid JSON data that matches the expected field structure.';
    }

    /**
     * Get system prompt for incident risk category generation
     */
    private function getIncidentRiskCategorySystemPrompt()
    {
        return 'You are an Australian workplace health and safety expert specializing in risk assessment and incident risk categorization. You have deep knowledge of Australian Work Health and Safety (WHS) Act 2011, WHS Regulations 2017, Australian Standards (AS), and risk management frameworks used in Australian workplaces.

CRITICAL REQUIREMENTS:
- ALL incident risk categories MUST comply with Australian WHS legislation and Australian Standards (AS)
- Use current Australian WHS terminology and compliance language
- Follow Australian risk assessment standards and regulatory requirements
- All risk categories must be relevant to Australian workplace safety practices
- Use appropriate Australian WHS legislation references and standards
- Ensure risk categories follow Australian risk management frameworks and best practices
- All data must be realistic and appropriate for Australian workplace contexts
- Include proper references to WHS Act sections and Australian Standards where applicable
- Focus on practical, risk-relevant categories that meet Australian compliance requirements
- Risk category titles should be clear, professional, and industry-specific
- Descriptions should explain the risk category, its significance, and compliance implications
- Risk levels should follow standard Australian risk assessment frameworks (Low, Medium, High, Extreme)

Generate realistic, professional incident risk categories that strictly follow Australian WHS standards and legislation. Return only valid JSON data that matches the expected field structure.';
    }

    /**
     * Get system prompt for WHS report settings generation
     */
    private function getWhsReportSettingsSystemPrompt()
    {
        return 'You are an Australian workplace health and safety expert specializing in WHS report configuration and settings. You have deep knowledge of Australian Work Health and Safety (WHS) Act 2011, WHS Regulations 2017, Australian Standards (AS), and WHS reporting requirements used in Australian workplaces.

CRITICAL REQUIREMENTS:
- ALL WHS report settings MUST comply with Australian WHS legislation and Australian Standards (AS)
- Use current Australian WHS terminology and compliance language
- Follow Australian WHS reporting standards and regulatory requirements
- All settings must be relevant to Australian workplace safety practices
- Use appropriate Australian WHS legislation references and standards
- Ensure settings follow Australian WHS frameworks and best practices
- All data must be realistic and appropriate for Australian workplace contexts
- Include proper references to WHS Act sections and Australian Standards where applicable
- Focus on practical, configuration-relevant settings that meet Australian compliance requirements
- Setting titles should be clear, professional, and industry-specific
- Settings should cover essential WHS reporting and compliance requirements
- Include settings for different types of WHS reports and assessments

Generate realistic, professional WHS report settings that strictly follow Australian WHS standards and legislation. Return only valid JSON data that matches the expected field structure.';
    }

    /**
     * Get system prompt for SWMS settings generation
     */
    private function getSwmsSettingsSystemPrompt()
    {
        return 'You are an Australian workplace health and safety expert specializing in Safe Work Method Statements (SWMS) and hazard/risk management. You have deep knowledge of Australian Work Health and Safety (WHS) Act 2011, WHS Regulations 2017, Australian Standards (AS), and SWMS requirements used in Australian workplaces.

CRITICAL REQUIREMENTS:
- ALL SWMS settings MUST comply with Australian WHS legislation and Australian Standards (AS)
- Use current Australian WHS terminology and compliance language
- Follow Australian SWMS standards and regulatory requirements
- All settings must be relevant to Australian workplace safety practices
- Use appropriate Australian WHS legislation references and standards
- Ensure settings follow Australian SWMS frameworks and best practices
- All data must be realistic and appropriate for Australian workplace contexts
- Include proper references to WHS Act sections and Australian Standards where applicable
- Focus on practical, SWMS-relevant settings that meet Australian compliance requirements
- Setting titles should be clear, professional, and industry-specific
- Settings should cover essential SWMS hazard and risk management requirements
- Include settings for different types of SWMS hazards and risks
- Follow Australian SWMS documentation and risk assessment standards
- Ensure all hazards and risks are relevant to Australian workplace safety

Generate realistic, professional SWMS settings that strictly follow Australian WHS standards and legislation. Return only valid JSON data that matches the expected field structure.';
    }

    /**
     * Get system prompt for SWMS safety planning questions generation
     */
    private function getSwmsSafetyPlanningQuestionSystemPrompt()
    {
        return 'You are an Australian workplace health and safety expert specializing in Safe Work Method Statements (SWMS) and safety planning. You have deep knowledge of Australian Work Health and Safety (WHS) Act 2011, WHS Regulations 2017, Australian Standards (AS), and SWMS safety planning requirements used in Australian workplaces.

CRITICAL REQUIREMENTS:
- ALL SWMS safety planning questions MUST comply with Australian WHS legislation and Australian Standards (AS)
- Use current Australian WHS terminology and compliance language
- Follow Australian SWMS safety planning standards and regulatory requirements
- All questions must be relevant to Australian workplace safety practices
- Use appropriate Australian WHS legislation references and standards
- Ensure questions follow Australian SWMS frameworks and best practices
- All data must be realistic and appropriate for Australian workplace contexts
- Include proper references to WHS Act sections and Australian Standards where applicable
- Focus on practical, SWMS-relevant safety planning questions that meet Australian compliance requirements
- Questions should be clear, professional, and industry-specific
- Questions should cover essential SWMS safety planning requirements
- Include questions for different types of SWMS safety planning scenarios
- Follow Australian SWMS documentation and safety planning standards
- Ensure all questions are relevant to Australian workplace safety planning

Generate realistic, professional SWMS safety planning questions that strictly follow Australian WHS standards and legislation. Return only valid JSON data that matches the expected field structure.';
    }

    /**
     * Get system prompt for SWMS general notes generation
     */
    private function getSwmsGeneralNoteSystemPrompt()
    {
        return 'You are an Australian workplace health and safety expert specializing in Safe Work Method Statements (SWMS) and general safety documentation. You have deep knowledge of Australian Work Health and Safety (WHS) Act 2011, WHS Regulations 2017, Australian Standards (AS), and SWMS documentation requirements used in Australian workplaces.

CRITICAL REQUIREMENTS:
- ALL SWMS general notes MUST comply with Australian WHS legislation and Australian Standards (AS)
- Use current Australian WHS terminology and compliance language
- Follow Australian SWMS documentation standards and regulatory requirements
- All notes must be relevant to Australian workplace safety practices
- Use appropriate Australian WHS legislation references and standards
- Ensure notes follow Australian SWMS frameworks and best practices
- All data must be realistic and appropriate for Australian workplace contexts
- Include proper references to WHS Act sections and Australian Standards where applicable
- Focus on practical, SWMS-relevant general notes that meet Australian compliance requirements
- Note titles should be clear, professional, and industry-specific
- Notes should cover essential SWMS documentation and safety requirements
- Include notes for different types of SWMS documentation scenarios
- Follow Australian SWMS documentation and safety standards
- Ensure all notes are relevant to Australian workplace safety documentation

Generate realistic, professional SWMS general notes that strictly follow Australian WHS standards and legislation. Return only valid JSON data that matches the expected field structure.';
    }

    /**
     * Get system prompt for SWMS protection tools generation
     */
    private function getSwmsProtectionToolsSystemPrompt()
    {
        return 'You are an Australian workplace health and safety expert specializing in Safe Work Method Statements (SWMS) and personal protective equipment (PPE). You have deep knowledge of Australian Work Health and Safety (WHS) Act 2011, WHS Regulations 2017, Australian Standards (AS), and SWMS protection tool requirements used in Australian workplaces.

CRITICAL REQUIREMENTS:
- ALL SWMS protection tools MUST comply with Australian WHS legislation and Australian Standards (AS)
- Use current Australian WHS terminology and compliance language
- Follow Australian SWMS documentation standards and regulatory requirements
- All protection tools must be relevant to Australian workplace safety practices
- Use appropriate Australian WHS legislation references and standards
- Ensure protection tools follow Australian SWMS frameworks and best practices
- All data must be realistic and appropriate for Australian workplace contexts
- Include proper references to WHS Act sections and Australian Standards where applicable
- Focus on practical, SWMS-relevant protection tools that meet Australian compliance requirements
- Protection tool titles should be clear, professional, and industry-specific
- Tools should cover essential SWMS safety equipment and protective measures
- Include tools for different types of SWMS safety scenarios
- Follow Australian SWMS documentation and safety standards
- Ensure all protection tools are relevant to Australian workplace safety requirements
- Focus on commonly used PPE and safety equipment in Australian construction and workplace settings

Generate realistic, professional SWMS protection tools that strictly follow Australian WHS standards and legislation. Return only valid JSON data that matches the expected field structure.';
    }

    /**
     * Build prompt for injury classification generation
     */
    private function buildInjuryClassificationPrompt($count, $industry, $includeDescriptions)
    {
        $industryContext = $this->aiService->getIndustryContext($industry);
        
        $descriptionInstruction = $includeDescriptions 
            ? "Include detailed descriptions that explain the injury type and severity. Each description MUST be maximum 250 characters long (not more than 250 characters)."
            : "Do NOT include descriptions - only titles are required";
        
        $jsonFormat = $includeDescriptions 
            ? '{
        "title": "Injury Classification Title",
        "description": "Detailed description of the injury classification following Australian standards",
        "status": 1
    }'
            : '{
        "title": "Injury Classification Title",
        "status": 1
    }';
        
        return "Generate {$count} realistic injury classifications for Australian workplace safety incident reporting in the {$industry} industry.

{$industryContext}

CRITICAL REQUIREMENTS:
- Generate injury classifications that are commonly seen in Australian {$industry} workplaces
- Each classification should have a clear, professional title
- {$descriptionInstruction}
- Use Australian WHS terminology and compliance language
- Ensure classifications follow Australian injury classification standards
- Make classifications realistic and appropriate for workplace safety reporting
- Include a mix of different injury types and severity levels
- Use current Australian workplace safety best practices

JSON STRUCTURE REQUIREMENTS:
- Return ONLY valid JSON with no additional text, explanations, or markdown formatting
- The response must start with '{{' and end with '}}'
- The 'classifications' array must contain exactly {$count} items
- Each item must have the exact structure shown below
- All titles must be unique and professional
- All descriptions (if included) must be detailed and informative
- CRITICAL: All descriptions MUST be maximum 250 characters long (not more than 250 characters)
- Status must always be 1 (active)

Return the data in this exact JSON format:
{
    \"classifications\": [
        {$jsonFormat}
    ]
}

CRITICAL: Ensure the response is valid JSON that can be parsed by json_decode(). Do not include any text before or after the JSON object.";
    }

    /**
     * Build prompt for notifiable classification generation
     */
    private function buildNotifiableClassificationPrompt($count, $industry, $includeDescriptions)
    {
        $industryContext = $this->aiService->getIndustryContext($industry);
        
        $descriptionInstruction = $includeDescriptions 
            ? "Include detailed descriptions that explain the notifiable incident criteria. Each description MUST be maximum 250 characters long (not more than 250 characters)."
            : "Do NOT include descriptions - only titles are required";
        
        $jsonFormat = $includeDescriptions 
            ? '{
        "title": "Notifiable Classification Title",
        "description": "Detailed description with WHS Act reference following Australian standards",
        "status": 1
    }'
            : '{
        "title": "Notifiable Classification Title",
        "status": 1
    }';
        
        return "Generate {$count} realistic notifiable incident classifications for Australian workplace safety incident reporting in the {$industry} industry.

{$industryContext}

CRITICAL REQUIREMENTS:
- Generate notifiable classifications that comply with Australian WHS Act 2011
- Focus on serious injuries, dangerous incidents, and fatalities as defined in the Act
- Each classification should reference relevant WHS Act sections (36, 37, 38)
- {$descriptionInstruction}
- CRITICAL: All descriptions MUST be maximum 250 characters long (not more than 250 characters)
- Use Australian WHS terminology and compliance language
- Ensure classifications follow Australian notifiable incident standards
- Make classifications realistic and appropriate for workplace safety reporting
- Include a mix of different notifiable incident types
- Use current Australian WHS legislation and regulatory requirements
- Reference specific WHS Act sections and definitions

Return the data in this exact JSON format:
{
    \"classifications\": [
        {$jsonFormat}
    ]
}

Only return valid JSON, no additional text or explanations. Ensure all classifications are contextually appropriate for Australian {$industry} workplaces and strictly follow Australian WHS legislation.";
    }

    /**
     * Build prompt for injury type generation
     */
    private function buildInjuryTypePrompt($count, $industry, $parentId, $includeDescriptions = true)
    {
        $industryContext = $this->aiService->getIndustryContext($industry);
        $parentContext = $parentId > 0 ? " These injury types should be subcategories of parent injury type ID {$parentId}." : "";
        
        // Build description instruction based on includeDescriptions parameter
        $descriptionInstruction = $includeDescriptions 
            ? "Include detailed descriptions that explain the injury type and medical context. Each description MUST be maximum 250 characters long (not more than 250 characters)."
            : "Do NOT include descriptions - only titles are required";
        
        $jsonFormat = $includeDescriptions 
            ? '{
        "title": "Injury Type Title",
        "description": "Detailed description of the injury type following Australian standards",
        "parent_id": ' . $parentId . ',
        "status": 1
    }'
            : '{
        "title": "Injury Type Title",
        "parent_id": ' . $parentId . ',
        "status": 1
    }';
        
        return "Generate {$count} realistic injury types for Australian workplace safety incident reporting in the {$industry} industry.{$parentContext}

{$industryContext}

Requirements:
- Generate injury types that are commonly seen in Australian {$industry} workplaces
- Each injury type should have a clear, professional title
- {$descriptionInstruction}
- CRITICAL: All descriptions MUST be maximum 250 characters long (not more than 250 characters)
- Use Australian WHS terminology and compliance language
- Ensure injury types follow Australian injury classification standards
- Make injury types realistic and appropriate for workplace safety reporting
- Include a mix of different injury categories (fractures, sprains, burns, etc.)
- Use current Australian workplace safety and medical best practices
- Follow standard medical injury classification frameworks

Return the data in this exact JSON format:
{
    \"injury_types\": [
        {$jsonFormat}
    ]
}

Only return valid JSON, no additional text or explanations. Ensure all injury types are contextually appropriate for Australian {$industry} workplaces and follow Australian WHS standards.";
    }

    /**
     * Build prompt for training generation
     */
    private function buildTrainingPrompt($count, $industry, $includeDescriptions)
    {
        $industryContext = $this->aiService->getIndustryContext($industry);
        
        $descriptionInstruction = $includeDescriptions 
            ? "Include detailed descriptions that explain the training purpose, content, and compliance benefits. Each description MUST be maximum 250 characters long (not more than 250 characters)."
            : "Do NOT include descriptions - only titles are required";
        
        $jsonFormat = $includeDescriptions 
            ? '{
        "title": "Training Program Title",
        "description": "Detailed description of the training program following Australian standards",
        "status": 1
    }'
            : '{
        "title": "Training Program Title",
        "status": 1
    }';
        
        return "Generate {$count} realistic training programs for Australian workplace health and safety in the {$industry} industry.

{$industryContext}

CRITICAL REQUIREMENTS:
- Generate training programs that comply with Australian WHS Act 2011 and Regulations 2017
- Focus on practical, workplace-relevant training that meets Australian compliance requirements
- Each training program should have a clear, professional title
- {$descriptionInstruction}
- CRITICAL: All descriptions MUST be maximum 250 characters long (not more than 250 characters)
- Use Australian WHS terminology and compliance language
- Ensure training programs follow Australian WHS standards and best practices
- Make training programs realistic and appropriate for workplace safety training
- Include a mix of different training types (induction, refresher, specialized, etc.)
- Use current Australian WHS legislation and regulatory requirements
- Reference specific WHS Act sections and Australian Standards where applicable
- Training should be industry-specific and address common hazards in {$industry}

Return the data in this exact JSON format:
{
    \"trainings\": [
        {$jsonFormat}
    ]
}

Only return valid JSON, no additional text or explanations. Ensure all training programs are contextually appropriate for Australian {$industry} workplaces and strictly follow Australian WHS legislation.";
    }

    /**
     * Build prompt for incident report question generation
     */
    private function buildIncidentReportQuestionPrompt($count, $industry, $includeDescriptions)
    {
        $industryContext = $this->aiService->getIndustryContext($industry);
        
        $descriptionInstruction = $includeDescriptions 
            ? "Include detailed descriptions that explain the question purpose, what information it seeks, and compliance benefits. Each description MUST be maximum 250 characters long (not more than 250 characters)."
            : "Do NOT include descriptions - only questions are required";
        
        $jsonFormat = $includeDescriptions 
            ? '{
        "question": "What specific question text?",
        "description": "Detailed description of what the question seeks and why it is important",
        "status": 1
    }'
            : '{
        "question": "What specific question text?",
        "status": 1
    }';
        
        return "Generate {$count} realistic incident report questions for Australian workplace health and safety incident investigation in the {$industry} industry.

{$industryContext}

CRITICAL REQUIREMENTS:
- Generate incident report questions that comply with Australian WHS Act 2011 and Regulations 2017
- Focus on practical, investigation-relevant questions that meet Australian compliance requirements
- Each question should be clear, professional, and designed to gather comprehensive incident information
- {$descriptionInstruction}
- CRITICAL: All descriptions MUST be maximum 250 characters long (not more than 250 characters)
- Use Australian WHS terminology and compliance language
- Ensure questions follow Australian incident investigation standards and best practices
- Make questions realistic and appropriate for workplace incident investigation
- Include a mix of different question types (general, investigation, compliance, prevention)
- Use current Australian WHS legislation and regulatory requirements
- Reference specific WHS Act sections and Australian Standards where applicable
- Questions should be industry-specific and address common incident scenarios in {$industry}
- Focus on gathering information needed for proper incident investigation and prevention

Question Types to Include:
- **General**: Basic incident information gathering
- **Investigation**: Root cause analysis and contributing factors
- **Compliance**: WHS Act and regulatory compliance verification
- **Prevention**: Future risk mitigation and control measures

Return the data in this exact JSON format:
{
    \"questions\": [
        {$jsonFormat}
    ]
}

Only return valid JSON, no additional text or explanations. Ensure all questions are contextually appropriate for Australian {$industry} workplaces and strictly follow Australian WHS legislation.";
    }

    /**
     * Build prompt for incident risk category generation
     */
    private function buildIncidentRiskCategoryPrompt($count, $industry, $riskLevel, $includeDescriptions = true)
    {
        $industryContext = $this->aiService->getIndustryContext($industry);
        
        // Build description instruction based on includeDescriptions parameter
        $descriptionInstruction = $includeDescriptions 
            ? "Include detailed descriptions that explain the risk category, its significance, and compliance implications. Each description MUST be maximum 250 characters long (not more than 250 characters)."
            : "Do NOT include descriptions - only titles are required";
        
        $jsonFormat = $includeDescriptions 
            ? '{
        "title": "Risk Category Title",
        "description": "Detailed description of the risk category following Australian standards",
        "status": 1
    }'
            : '{
        "title": "Risk Category Title",
        "status": 1
    }';
        
        return "Generate {$count} realistic incident risk categories for Australian workplace health and safety risk assessment in the {$industry} industry.

{$industryContext}

CRITICAL REQUIREMENTS:
- Generate incident risk categories that comply with Australian WHS Act 2011 and Regulations 2017
- Focus on practical, risk-relevant categories that meet Australian compliance requirements
- Each risk category should have a clear, professional title
- {$descriptionInstruction}
- CRITICAL: All descriptions MUST be maximum 250 characters long (not more than 250 characters)
- Use Australian WHS terminology and compliance language
- Ensure risk categories follow Australian risk management standards and best practices
- Make risk categories realistic and appropriate for workplace risk assessment
- Include a mix of different risk types and severity levels
- Use current Australian WHS legislation and regulatory requirements
- Reference specific WHS Act sections and Australian Standards where applicable
- Risk categories should be industry-specific and address common hazards in {$industry}
- Focus on risk levels appropriate for {$riskLevel} risk assessment
- Follow standard Australian risk assessment frameworks (Low, Medium, High, Extreme)

Risk Levels to Consider:
- **Low**: Minimal risk, easily controlled, minor consequences
- **Medium**: Moderate risk, requires attention, moderate consequences
- **High**: Significant risk, immediate attention required, serious consequences
- **Extreme**: Critical risk, immediate action required, severe consequences

Return the data in this exact JSON format:
{
    \"risk_categories\": [
        {$jsonFormat}
    ]
}

Only return valid JSON, no additional text or explanations. Ensure all risk categories are contextually appropriate for Australian {$industry} workplaces and strictly follow Australian WHS legislation.";
    }

    /**
     * Build prompt for WHS report settings generation
     */
    private function buildWhsReportSettingsPrompt($count, $industry, $settingType, $includeDescriptions = true)
    {
        $industryContext = $this->aiService->getIndustryContext($industry);
        
        // Build description instruction based on includeDescriptions parameter
        $descriptionInstruction = $includeDescriptions 
            ? "Each setting should have a clear, professional title and description. Each description MUST be maximum 250 characters long (not more than 250 characters)."
            : "Each setting should have a clear, professional title ONLY - do NOT include descriptions";
        
        $jsonFormat = $includeDescriptions 
            ? '{
        "title": "WHS Setting Title",
        "description": "Detailed description of the WHS setting following Australian standards",
        "status": 1
    }'
            : '{
        "title": "WHS Setting Title",
        "status": 1
    }';
        
        return "Generate {$count} realistic WHS report settings for Australian workplace health and safety reporting in the {$industry} industry.

{$industryContext}

CRITICAL REQUIREMENTS:
- Generate WHS report settings that comply with Australian WHS Act 2011 and Regulations 2017
- Focus on practical, configuration-relevant settings that meet Australian compliance requirements
- Each setting should have a clear, professional title
- {$descriptionInstruction}
- CRITICAL: All descriptions MUST be maximum 250 characters long (not more than 250 characters)
- Settings should cover essential WHS reporting and compliance requirements
- Use Australian WHS terminology and compliance language
- Ensure settings follow Australian WHS standards and best practices
- Make settings realistic and appropriate for workplace WHS reporting
- Include a mix of different setting types ({$settingType} focus)
- Use current Australian WHS legislation and regulatory requirements
- Reference specific WHS Act sections and Australian Standards where applicable
- Settings should be industry-specific and address common WHS reporting needs in {$industry}
- Focus on settings needed for proper WHS compliance and reporting

Setting Types to Include:
- **General**: Basic WHS report configuration settings
- **Compliance**: WHS Act and regulatory compliance settings
- **Reporting**: Report format and content settings
- **Assessment**: Risk assessment and evaluation settings

Return the data in this exact JSON format:
{
    \"whs_items\": [
        {$jsonFormat}
    ]
}

Only return valid JSON, no additional text or explanations. Ensure all settings are contextually appropriate for Australian {$industry} workplaces and strictly follow Australian WHS legislation.";
    }

    /**
     * Build prompt for SWMS settings generation
     */
    private function buildSwmsSettingsPrompt($count, $industry, $settingType, $swmsType = null, $includeDescriptions = true)
    {
        $industryContext = $this->aiService->getIndustryContext($industry);
        
        // Build type-specific instruction
        $typeInstruction = '';
        $typeRequirement = '';
        $defaultType = 'hazard';
        
        if ($swmsType) {
            if ($swmsType === 'hazard') {
                $typeInstruction = "CRITICAL: Generate ONLY hazard type records. Focus on physical, chemical, biological, ergonomic, and psychosocial hazards.";
                $typeRequirement = "- ALL generated records MUST be of type 'hazard'";
                $defaultType = 'hazard';
            } elseif ($swmsType === 'risk') {
                $typeInstruction = "CRITICAL: Generate ONLY risk type records. Focus on risk assessment, control measures, and risk management settings.";
                $typeRequirement = "- ALL generated records MUST be of type 'risk'";
                $defaultType = 'risk';
            }
        } else {
            $typeInstruction = "Include both hazard and risk type settings as appropriate.";
            $typeRequirement = "";
            $defaultType = 'hazard';
        }

        // Build description instruction based on includeDescriptions parameter
        $descriptionInstruction = $includeDescriptions 
            ? "Each setting should have a clear, professional title and description. Each description MUST be maximum 250 characters long (not more than 250 characters)."
            : "Each setting should have a clear, professional title ONLY - do NOT include descriptions";
        
        $jsonFormat = $includeDescriptions 
            ? '{
        "title": "SWMS Setting Title",
        "description": "Detailed description of the SWMS setting",
        "type": "' . $defaultType . '",
        "status": 1
    }'
            : '{
        "title": "SWMS Setting Title",
        "type": "' . $defaultType . '",
        "status": 1
    }';
        
        return "Generate {$count} realistic SWMS (Safe Work Method Statement) settings for Australian workplace health and safety in the {$industry} industry.

{$industryContext}

{$typeInstruction}

CRITICAL REQUIREMENTS:
- Generate SWMS settings that comply with Australian WHS Act 2011 and Regulations 2017
- Focus on practical, SWMS-relevant settings that meet Australian compliance requirements
- {$descriptionInstruction}
- CRITICAL: All descriptions MUST be maximum 250 characters long (not more than 250 characters)
- Settings should cover essential SWMS hazard and risk management requirements
- Use Australian WHS terminology and compliance language
- Ensure settings follow Australian SWMS standards and best practices
- Make settings realistic and appropriate for workplace SWMS documentation
- Include a mix of different setting types ({$settingType} focus)
- Use current Australian WHS legislation and regulatory requirements
- Reference specific WHS Act sections and Australian Standards where applicable
- Settings should be industry-specific and address common SWMS needs in {$industry}
- Focus on settings needed for proper SWMS compliance and risk management
{$typeRequirement}

Setting Types to Include:
- **Hazard**: Physical, chemical, biological, ergonomic, and psychosocial hazards
- **Risk**: Risk assessment, control measures, and risk management settings
- **General**: Basic SWMS configuration and documentation settings
- **Compliance**: SWMS Act and regulatory compliance settings

Return the data in this exact JSON format:
{
    \"hazard_risks\": [
        {$jsonFormat}
    ]
}

Only return valid JSON, no additional text or explanations. Ensure all settings are contextually appropriate for Australian {$industry} workplaces and strictly follow Australian WHS legislation and SWMS requirements.";
    }

    /**
     * Build prompt for SWMS safety planning questions generation
     */
    private function buildSwmsSafetyPlanningQuestionPrompt($count, $industry, $settingType, $swmsType = null, $includeDescriptions = true)
    {
        $industryContext = $this->aiService->getIndustryContext($industry);
        
        // Build type-specific instruction
        $typeInstruction = '';
        $typeRequirement = '';
        $defaultType = 'hazard';
        
        if ($swmsType) {
            if ($swmsType === 'hazard') {
                $typeInstruction = "CRITICAL: Generate ONLY hazard type questions. Focus on physical, chemical, biological, ergonomic, and psychosocial hazard identification and assessment.";
                $typeRequirement = "- ALL generated questions MUST be of type 'hazard'";
                $defaultType = 'hazard';
            } elseif ($swmsType === 'risk') {
                $typeInstruction = "CRITICAL: Generate ONLY risk type questions. Focus on risk assessment, control measures, and risk management planning.";
                $typeRequirement = "- ALL generated questions MUST be of type 'risk'";
                $defaultType = 'risk';
            }
        } else {
            $typeInstruction = "Include both hazard and risk type questions as appropriate.";
            $typeRequirement = "";
            $defaultType = 'hazard';
        }

        // Build description instruction based on includeDescriptions parameter
        $descriptionInstruction = $includeDescriptions 
            ? "Each question should have a clear, professional question text and description. Each description MUST be maximum 250 characters long (not more than 250 characters)."
            : "Each question should have a clear, professional question text ONLY - do NOT include descriptions";
        
        $jsonFormat = $includeDescriptions 
            ? '{
        "question": "SWMS Safety Planning Question Text",
        "description": "Detailed description or context for the safety planning question",
        "type": "' . $defaultType . '"
    }'
            : '{
        "question": "SWMS Safety Planning Question Text",
        "type": "' . $defaultType . '"
    }';
        
        return "Generate {$count} realistic SWMS (Safe Work Method Statement) safety planning questions for Australian workplace health and safety in the {$industry} industry.

{$industryContext}

{$typeInstruction}

CRITICAL REQUIREMENTS:
- Generate SWMS safety planning questions that comply with Australian WHS Act 2011 and Regulations 2017
- Focus on practical, SWMS-relevant safety planning questions that meet Australian compliance requirements
- {$descriptionInstruction}
- CRITICAL: All descriptions MUST be maximum 250 characters long (not more than 250 characters)
- Questions should cover essential SWMS safety planning requirements
- Use Australian WHS terminology and compliance language
- Ensure questions follow Australian SWMS standards and best practices
- Make questions realistic and appropriate for workplace SWMS safety planning
- Include a mix of different question types ({$settingType} focus)
- Use current Australian WHS legislation and regulatory requirements
- Reference specific WHS Act sections and Australian Standards where applicable
- Questions should be industry-specific and address common SWMS safety planning needs in {$industry}
- Focus on questions needed for proper SWMS safety planning compliance
{$typeRequirement}

Question Types to Include:
- **Hazard**: Questions about hazard identification, assessment, and control
- **Risk**: Questions about risk assessment, control measures, and risk management planning
- **General**: Basic SWMS safety planning and documentation questions
- **Compliance**: SWMS Act and regulatory compliance questions

Return the data in this exact JSON format:
{
    \"safety_planning_questions\": [
        {$jsonFormat}
    ]
}

Only return valid JSON, no additional text or explanations. Ensure all questions are contextually appropriate for Australian {$industry} workplaces and strictly follow Australian WHS legislation and SWMS requirements.";
    }

    /**
     * Build prompt for SWMS general notes generation
     */
    private function buildSwmsGeneralNotePrompt($count, $industry, $settingType, $swmsType = null, $includeDescriptions = true)
    {
        $industryContext = $this->aiService->getIndustryContext($industry);
        
        // Build type-specific instruction
        $typeInstruction = '';
        $typeRequirement = '';
        $defaultType = 'general';
        
        if ($swmsType) {
            if ($swmsType === 'hazard') {
                $typeInstruction = "CRITICAL: Generate ONLY hazard type notes. Focus on physical, chemical, biological, ergonomic, and psychosocial hazard documentation and safety notes.";
                $typeRequirement = "- ALL generated notes MUST be of type 'hazard'";
                $defaultType = 'hazard';
            } elseif ($swmsType === 'risk') {
                $typeInstruction = "CRITICAL: Generate ONLY risk type notes. Focus on risk assessment, control measures, and risk management documentation.";
                $typeRequirement = "- ALL generated notes MUST be of type 'risk'";
                $defaultType = 'risk';
            }
        } else {
            $typeInstruction = "Include a mix of general, hazard, and risk type notes as appropriate.";
            $typeRequirement = "";
            $defaultType = 'general';
        }
        
        $descriptionInstruction = $includeDescriptions 
            ? "Include detailed descriptions that explain the general note purpose and content. Each description MUST be maximum 250 characters long (not more than 250 characters)."
            : "Do NOT include descriptions - only titles are required";
        
        $jsonFormat = $includeDescriptions 
            ? '{
        "title": "SWMS General Note Title",
        "description": "Detailed description of the general note following Australian standards",
        "type": "' . $defaultType . '"
    }'
            : '{
        "title": "SWMS General Note Title",
        "type": "' . $defaultType . '"
    }';
        
        return "Generate {$count} realistic SWMS general notes for Australian workplace safety documentation in the {$industry} industry.

{$industryContext}

{$typeInstruction}

CRITICAL REQUIREMENTS:
- Generate SWMS general notes that comply with Australian WHS Act 2011 and Regulations 2017
- Focus on practical, SWMS-relevant documentation notes that meet Australian compliance requirements
- Each note should have a clear, professional title
- {$descriptionInstruction}
- CRITICAL: All descriptions MUST be maximum 250 characters long (not more than 250 characters)
- Notes should cover essential SWMS documentation and safety requirements
- Use Australian WHS terminology and compliance language
- Ensure notes follow Australian SWMS documentation standards
- Make notes realistic and appropriate for workplace SWMS documentation
- Include a mix of different note types ({$settingType} focus)
- Use current Australian WHS legislation and regulatory requirements
- Reference specific WHS Act sections and Australian Standards where applicable
- Notes should be industry-specific and address common SWMS documentation needs in {$industry}
- Focus on notes needed for proper SWMS compliance and documentation
{$typeRequirement}

Note Types to Include:
- **General**: Basic SWMS documentation and safety notes
- **Hazard**: Notes about hazard identification, assessment, and control documentation
- **Risk**: Notes about risk assessment, control measures, and risk management documentation
- **Compliance**: SWMS Act and regulatory compliance documentation notes

Return the data in this exact JSON format:
{
    \"general_notes\": [
        {$jsonFormat}
    ]
}

Only return valid JSON, no additional text or explanations. Ensure all notes are contextually appropriate for Australian {$industry} workplaces and strictly follow Australian WHS legislation and SWMS requirements.";
    }

    /**
     * Build prompt for SWMS protection tools generation
     */
    private function buildSwmsProtectionToolsPrompt($count, $industry, $settingType, $swmsType = null, $includeDescriptions = true)
    {
        $industryContext = $this->aiService->getIndustryContext($industry);
        
        // Build type-specific instruction
        $typeInstruction = '';
        $typeRequirement = '';
        
        if ($swmsType) {
            if ($swmsType === 'hazard') {
                $typeInstruction = "CRITICAL: Generate ONLY hazard-specific protection tools. Focus on PPE and safety equipment needed for physical, chemical, biological, ergonomic, and psychosocial hazard protection.";
                $typeRequirement = "- ALL generated protection tools MUST be specifically designed for hazard protection scenarios";
            } elseif ($swmsType === 'risk') {
                $typeInstruction = "CRITICAL: Generate ONLY risk-specific protection tools. Focus on PPE and safety equipment needed for risk mitigation, control measures, and risk management scenarios.";
                $typeRequirement = "- ALL generated protection tools MUST be specifically designed for risk management scenarios";
            }
        } else {
            $typeInstruction = "Include a mix of protection tools for various hazard and risk scenarios as appropriate.";
            $typeRequirement = "";
        }
        
        $descriptionInstruction = $includeDescriptions 
            ? "Include detailed descriptions that explain the protection tool purpose and usage. Each description MUST be maximum 250 characters long (not more than 250 characters)."
            : "Do NOT include descriptions - only titles are required";
        
        $jsonFormat = $includeDescriptions 
            ? '{
        "title": "SWMS Protection Tool Title",
        "description": "Detailed description of the protection tool following Australian standards",
        "image": null
    }'
            : '{
        "title": "SWMS Protection Tool Title",
        "image": null
    }';
        
        return "Generate {$count} realistic SWMS protection tools for Australian workplace safety in the {$industry} industry.

{$industryContext}

{$typeInstruction}

CRITICAL REQUIREMENTS:
- Generate SWMS protection tools that comply with Australian WHS Act 2011 and Regulations 2017
- Focus on practical, SWMS-relevant protection tools that meet Australian compliance requirements
- Each tool should have a clear, professional title
- {$descriptionInstruction}
- CRITICAL: All descriptions MUST be maximum 250 characters long (not more than 250 characters)
- Use Australian WHS terminology and compliance language
- Ensure tools follow Australian SWMS safety standards
- Make tools realistic and appropriate for workplace safety protection
- Include a mix of different types of personal protective equipment (PPE)
- Use current Australian workplace safety best practices
- Focus on practical SWMS safety equipment requirements
- Tools should cover essential SWMS safety protection measures
- Include tools for different types of SWMS safety scenarios
- Follow Australian SWMS documentation and safety standards
- Ensure all protection tools are relevant to Australian workplace safety requirements
- Focus on commonly used PPE and safety equipment in Australian construction and workplace settings
{$typeRequirement}

Protection Tool Categories to Include:
- **Head Protection**: Helmets, hard hats, face shields
- **Eye Protection**: Safety glasses, goggles, welding shields
- **Hearing Protection**: Ear muffs, ear plugs, communication headsets
- **Respiratory Protection**: Masks, respirators, breathing apparatus
- **Hand Protection**: Gloves, mitts, barrier creams
- **Body Protection**: Coveralls, vests, aprons, safety harnesses
- **Foot Protection**: Safety boots, shoes, toe caps
- **Fall Protection**: Harnesses, lanyards, anchor points

Return the data in this exact JSON format:
{
    \"protection_tools\": [
        {$jsonFormat}
    ]
}

Only return valid JSON, no additional text or explanations. Ensure all protection tools are contextually appropriate for Australian {$industry} workplaces and strictly follow Australian WHS legislation and SWMS requirements.";
    }
}
