<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmpPersonalDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('emp_personal_details', function (Blueprint $table) {

            $table->id();
            $table->string('emp_id');
            $table->string('first_name');
            $table->string('middle_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('mobile');
            $table->string('streat_address');
            $table->string('suburb');
            $table->string('state');
            $table->string('postcode');
            $table->string('image')->default('upload/images/default.png');
            $table->string('date_of_birth');
            $table->string('blood_group')->nullable();
            $table->string('bank_name')->nullable();
            $table->string('account_holder_name')->nullable();
            $table->string('ibn_number')->nullable();
            $table->string('account_number')->nullable();
            $table->string('created_by');
            $table->string('del')->default('0');
            $table->timestamps();
            
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('emp_personal_details');
    }
}
