<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRequiredDocumentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('required_documents', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->integer('customer_id')->nullable(); // Makes the column nullable
            $table->integer('workspace_id')->nullable(); // Makes the column nullable
            $table->string('identity_text')->default('0');
            $table->string('identity_file')->default('0');
            $table->integer('priority')->default(1);
            $table->string('del')->default('0');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('required_documents');
    }
}
