<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('whsqe_report_logs', function (Blueprint $table) {
            $table->id();
            $table->integer('report_id');
            $table->integer('employee_id');
            $table->string('action_type'); // 'create', 'edit', 'delete', etc.
            $table->string('step_number')->nullable(); // For tracking which step was modified
            $table->text('message');
            $table->json('changes')->nullable(); // Store what was changed
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('whsqe_report_logs');
    }
};
