<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateIncidentClassificationReportsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('incident_classification_reports', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('incident_report_id')->default(0);
            $table->integer('injury_classification_id')->default(0);
            $table->text('details')->nullable();
            $table->integer('type')->default(0); // Initial/Final
            $table->timestamps();
            $table->foreign('incident_report_id')->references('id')->on('incident_reports')->onDelete('cascade')->onUpdate('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('incident_classification_reports');
    }
}
