<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateIncidentInvolvedPersonDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('incident_involved_person_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('incident_report_id')->default(0);
            $table->integer('employee_id')->default(0);
            $table->string('surname')->nullable();
            $table->string('contact_number')->nullable();
            $table->integer('gender')->default(0);
            $table->string('dob')->nullable();
            $table->integer('age')->default(0);
            $table->integer('is_type_emp')->nullable();
            $table->integer('is_inj_detail')->nullable();
            $table->string('occupation')->nullable();
            $table->string('language')->nullable();
            $table->integer('experience_years')->default(0);
            $table->string('experience_months')->nullable();
            $table->integer('employment_type')->default(0);
            $table->string('employee_type')->nullable();
            $table->integer('shift_type')->default(0);
            $table->string('shift_time')->nullable();
            $table->timestamps();
            $table->foreign('incident_report_id') ->references('id') ->on('incident_reports')->onDelete('cascade')->onUpdate('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('incident_involved_person_details');
    }
}
