<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInspectionPlanGeneralsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('inspection_plan_generals', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('inspection_plan_id');
            $table->string('itp_reference_number')->nullable();
            $table->unsignedBigInteger('iptc_id')->nullable();
            $table->string('level')->nullable();
            $table->string('to_level')->nullable();
            $table->string('pour')->nullable();
            $table->string('zone')->nullable();
            $table->string('company_group_name')->nullable();
            $table->string('principal_name')->nullable();
            $table->date('principal_date')->nullable();
            $table->date('company_group_date')->nullable();
            
            // $table->string('name')->nullable();
            $table->string('architectural_drawing_number')->nullable();
            $table->string('structectural_drawing_number')->nullable();
            $table->string('Post_Tension_Drawing_Number')->nullable();
            $table->enum('partial_handover', ['0', '1'])->default('0');
            $table->date('partial_Handover_date')->nullable();
            $table->time('partial_Handover_time')->nullable();
            $table->string('partial_Handover_location')->nullable();
            $table->enum('complete_handover', ['0', '1'])->default('0');
            $table->date('complete_handover_date')->nullable();
            $table->time('complete_handover_time')->nullable();
            $table->string('complete_handover_Location')->nullable();
            $table->text('description_box_for_message')->nullable();            
            $table->string('is_complete')->nullable();

            $table->string('del')->default(0);

            $table->timestamps();

            $table->foreign('inspection_plan_id')->references('id')->on('inspection_plans')->onDelete('cascade')->onUpdate('cascade');
            // $table->foreign('itpc_id')->references('id')->on('inspection_plan_checklists')->onDelete('cascade')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('inspection_plan_generals');
    }
}
