<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddMeetingNotesInMeetingDocumentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $columnExists = Schema::hasColumn('meeting_documents', 'meeting_notes');

        if (!$columnExists) {
            Schema::table('meeting_documents', function (Blueprint $table) {
                $table->longText('meeting_notes')->nullable()->after('is_signed');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('meeting_documents', function (Blueprint $table) {
            //
        });
    }
}
