<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSwmsProtectionToolPivotsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('swms_protection_tool_pivots', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('swms_id')->nullable();
            $table->unsignedBigInteger('protection_tool_id')->nullable();

            $table->timestamps();
            $table->foreign('swms_id')->references('id')->on('swms')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('protection_tool_id')->references('id')->on('swms_protection_tools')->onDelete('cascade')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('swms_protection_tool_pivots');
    }
}
