<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePlansTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('plans', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->integer('number_of_user')->nullable();
            $table->string('custom_plan')->nullable();
            $table->integer('active')->nullable();
            $table->integer('is_free_plan')->nullable();
            $table->integer('status')->nullable();
            $table->integer('package_price_monthly')->nullable();
            $table->integer('package_price_yearly')->nullable();
            $table->integer('price_per_user_monthly')->nullable();
            $table->integer('price_per_user_yearly')->nullable();
            $table->integer('price_per_workspace_monthly')->nullable();
            $table->integer('price_per_workspace_yearly')->nullable();
            $table->string('module_id')->nullable();
            $table->integer('number_of_workspace')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('plans');
    }
}
