<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->string('order_id')->nullable();
            $table->string('name')->nullable();
            $table->string('email')->nullable();
            $table->string('plan_name')->nullable();
            $table->boolean('is_recurring')->default(false)->nullable();
            $table->unsignedBigInteger('plan_id')->nullable();
            $table->integer('price')->nullable();
            $table->string('price_curency')->nullable();
            $table->string('payment_type')->nullable();
            $table->string('txn_id')->nullable();
            $table->integer('payment_status')->nullable();
            $table->string('coupon_code')->nullable();
            $table->string('discount_amount')->nullable();
            $table->string('refferal_code')->nullable();
            $table->integer('interval')->nullable();
            $table->string('receipt')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->unsignedBigInteger('workspace')->nullable();
            $table->integer('is_refund')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
}
