<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('referral_leads', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('referral_user_id');
            $table->unsignedBigInteger('customer_id')->nullable(); // When they sign up
            $table->string('email')->nullable();
            $table->string('name')->nullable();
            $table->string('phone')->nullable();
            $table->enum('status', ['pending', 'converted', 'expired'])->default('pending');
            $table->string('referral_code')->index();
            $table->timestamp('converted_at')->nullable();
            $table->json('meta_data')->nullable(); // Additional lead data
            $table->timestamps();

            $table->foreign('referral_user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('customer_id')->references('id')->on('users')->onDelete('set null');
            $table->index(['referral_user_id', 'status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('referral_leads');
    }
};
