<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddIsSiteEmployeeToSignaturesTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Add is_site_employee column to incident_signoffs table
        Schema::table('incident_signoffs', function (Blueprint $table) {
            $table->boolean('is_site_employee')->default(0)->after('emp_id')
                ->comment('0 = pre-signed employee, 1 = site employee');
        });

        // Add is_site_employee column to inspection_plan_signatures table
        Schema::table('inspection_plan_signatures', function (Blueprint $table) {
            $table->boolean('is_site_employee')->default(0)->after('employee_id')
                ->comment('0 = pre-signed employee, 1 = site employee');
        });

        // Add is_site_employee column to swms_signatures table
        Schema::table('swms_signatures', function (Blueprint $table) {
            $table->boolean('is_site_employee')->default(0)->after('emp_id')
                ->comment('0 = pre-signed employee, 1 = site employee');
        });

        // Add is_site_employee column to whs_signatures table
        Schema::table('whs_signatures', function (Blueprint $table) {
            $table->boolean('is_site_employee')->default(0)->after('employee_id')
                ->comment('0 = pre-signed employee, 1 = site employee');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Remove is_site_employee column from incident_signoffs table
        Schema::table('incident_signoffs', function (Blueprint $table) {
            $table->dropColumn('is_site_employee');
        });

        // Remove is_site_employee column from inspection_plan_signatures table
        Schema::table('inspection_plan_signatures', function (Blueprint $table) {
            $table->dropColumn('is_site_employee');
        });

        // Remove is_site_employee column from swms_signatures table
        Schema::table('swms_signatures', function (Blueprint $table) {
            $table->dropColumn('is_site_employee');
        });

        // Remove is_site_employee column from whs_signatures table
        Schema::table('whs_signatures', function (Blueprint $table) {
            $table->dropColumn('is_site_employee');
        });
    }
}
