<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateFaqsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('faqs', function (Blueprint $table) {
            // Remove individual question and answers columns as they'll be in faq_items
            $table->dropColumn(['question', 'answers']);
            
            // Add new columns for better organization
            $table->string('title')->after('id'); // Title for the FAQ group
            $table->text('description')->nullable()->after('title'); // Description of the FAQ group
            $table->integer('sort_order')->default(0)->after('page_slug');
            
            // Add indexes for better performance
            $table->index(['module_id', 'status']);
            $table->index(['page_slug', 'status']);
            $table->index('sort_order');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('faqs', function (Blueprint $table) {
            // Add back the original columns
            $table->text('question')->nullable();
            $table->text('answers')->nullable();
            
            // Remove new columns
            $table->dropColumn(['title', 'description', 'sort_order']);
            
            // Drop indexes
            $table->dropIndex(['module_id', 'status']);
            $table->dropIndex(['page_slug', 'status']);
            $table->dropIndex(['sort_order']);
        });
    }
}