<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('whsqe_customer_selected_settings', function (Blueprint $table) {
            // Add unique constraint to prevent duplicate entries
            // A combination of report_id, customer_id, workspace_id, parent_id, child_id, and grandchild_id should be unique
            $table->unique(
                ['whsq_report_id', 'customer_id', 'workspace_id', 'parent_id', 'child_id', 'grandchild_id'],
                'whsq_settings_unique_constraint'
            );
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('whsqe_customer_selected_settings', function (Blueprint $table) {
            // Drop the unique constraint
            $table->dropUnique('whsq_settings_unique_constraint');
        });
    }
};
