<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSubcontractorCompaniesTable extends Migration
{
    /**
     * Run the migrations.
     * 
     * This migration adds a required_docs_status column to track document upload status:
     * - 0 = Required documents NOT uploaded (default)
     * - 1 = Required documents uploaded and approved by admin
     * - 2 = Required documents were uploaded, but company added NEW documents after that
     * - 3 = Required documents uploaded but rejected by admin
     * - 4 = Required documents uploaded and pending admin approval
     *
     * @return void
     */
    public function up()
    {
        Schema::create('subcontractor_companies', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('customer_id')->nullable();
            $table->unsignedBigInteger('workspace_id')->nullable();
            $table->unsignedBigInteger('trade_id')->nullable();
            $table->json('project_ids')->nullable();
            $table->tinyInteger('required_docs_status')->default(0)->comment('0=not uploaded, 1=approved, 2=new docs added, 3=rejected, 4=pending approval');
            $table->string('del')->default('0');
            $table->timestamps();

            // Foreign key constraint
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('subcontractor_companies');
    }
}

