<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('subcontractor_employee_invitations', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('employee_id')->comment('Reference to employees_subcontractors table');
            $table->unsignedBigInteger('subcontractor_id')->comment('Reference to users table (subcontractor)');
            $table->unsignedBigInteger('project_id')->comment('Reference to projects table');
            $table->unsignedBigInteger('customer_id')->comment('Reference to users table (customer/company)');
            $table->unsignedBigInteger('workspace_id')->nullable()->comment('Workspace ID');
            $table->enum('invitation_status', ['pending', 'accepted', 'rejected'])->default('pending');
            $table->text('rejection_reason')->nullable();
            $table->timestamp('responded_at')->nullable();
            $table->timestamps();

            // Indexes for better query performance
            $table->index('employee_id');
            $table->index('subcontractor_id');
            $table->index('project_id');
            $table->index('customer_id');
            $table->index('invitation_status');
            
            // Unique constraint to prevent duplicate invitations
            $table->unique(['employee_id', 'subcontractor_id', 'project_id'], 'unique_emp_subcon_project');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('subcontractor_employee_invitations');
    }
};

