<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('subcontractor_employee_documents', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('employee_id')->comment('Reference to employees_subcontractors table');
            $table->unsignedBigInteger('subcontractor_id')->comment('Reference to users table (subcontractor)');
            $table->unsignedBigInteger('project_id')->comment('Reference to projects table');
            $table->unsignedBigInteger('customer_id')->comment('Reference to users table (customer/company)');
            $table->unsignedBigInteger('workspace_id')->nullable()->comment('Workspace ID');
            $table->unsignedBigInteger('required_document_id')->comment('Reference to required_documents table');
            $table->unsignedBigInteger('required_document_field_id')->comment('Reference to required_document_fields table');
            $table->text('value')->nullable()->comment('Document value (file path or text)');
            $table->enum('approval_status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->text('rejection_reason')->nullable();
            $table->unsignedBigInteger('approved_by')->nullable()->comment('User who approved/rejected');
            $table->timestamp('approved_at')->nullable();
            $table->string('del', 1)->default('0');
            $table->timestamps();

            // Indexes for better query performance
            $table->index('employee_id');
            $table->index('subcontractor_id');
            $table->index('project_id');
            $table->index('customer_id');
            $table->index('required_document_id');
            $table->index('approval_status');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('subcontractor_employee_documents');
    }
};

