<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('subcontractor_employee_invitations', function (Blueprint $table) {
            // Status column for each company to manage active/inactive employees
            // 1 = active, 0 = inactive (similar to emp_company_details.status)
            $table->tinyInteger('status')->default(1)->after('invitation_status')
                ->comment('1=active, 0=inactive - each company can manage independently');
            
            // Index for filtering by status
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('subcontractor_employee_invitations', function (Blueprint $table) {
            $table->dropIndex(['status']);
            $table->dropColumn('status');
        });
    }
};

