<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddSignedFileToInductionDocumentSignaturesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('induction_document_signatures', 'signed_file')) {
            Schema::table('induction_document_signatures', function (Blueprint $table) {
                // Store the path to the signed PDF file (document with signature embedded)
                $table->string('signed_file')->nullable()->after('signature_path');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('induction_document_signatures', function (Blueprint $table) {
            $table->dropColumn('signed_file');
        });
    }
}
