<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddSubcontractorIdToRosterTemplatesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('roster_templates', function (Blueprint $table) {
            $table->unsignedBigInteger('subcontractor_id')
                  ->nullable()
                  ->after('id'); // adjust position if needed
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('roster_templates', function (Blueprint $table) {
            $table->dropColumn('subcontractor_id');
        });
    }
}
