<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddSubcontractorIdToRosterAssignsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::table('roster_assigns', function (Blueprint $table) {
            $table->unsignedBigInteger('subcontractor_id')
                  ->nullable()
                  ->after('id'); // adjust column position if needed

            // Optional but recommended
            $table->index('subcontractor_id');
        });
    }

    public function down(): void
    {
        Schema::table('roster_assigns', function (Blueprint $table) {
            $table->dropIndex(['subcontractor_id']);
            $table->dropColumn('subcontractor_id');
        });
    }
}
