<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddProjectIdToMeetingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('meetings', function (Blueprint $table) {
            if (!Schema::hasColumn('meetings', 'project_id')) {
                $table->unsignedBigInteger('project_id')->nullable()->after('site_id');
            }
        });
        Schema::table('meeting_users', function (Blueprint $table) {
            if (!Schema::hasColumn('meeting_users', 'user_type')) {
                $table->tinyInteger('user_type')->default(0)->after('employee_id')->comment('0 = regular employee, 1 = subcontractor employee');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('meetings', function (Blueprint $table) {
            if (Schema::hasColumn('meetings', 'project_id')) {
                $table->dropColumn('project_id');
            }
        });
        Schema::table('meeting_users', function (Blueprint $table) {
            if (Schema::hasColumn('meeting_users', 'user_type')) {
                $table->dropColumn('user_type');
            }
        });
    }
}
