<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddEmpTypeAndSubcontractorIdToXeroPayslipHistoryTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('xero_payslip_history', function (Blueprint $table) {
            $table->string('emp_type')->nullable()->after('employee_id');
            $table->integer('subcontractor_id')->nullable()->after('emp_type');
            
            // Add index for better query performance
            $table->index('emp_type');
            $table->index('subcontractor_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('xero_payslip_history', function (Blueprint $table) {
            $table->dropIndex(['emp_type']);
            $table->dropIndex(['subcontractor_id']);
            $table->dropColumn(['emp_type', 'subcontractor_id']);
        });
    }
}
