<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProjectManagementHistoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('project_management_histories', function (Blueprint $table) {
            $table->id();
            $table->integer('project_management_id')->nullable();
            $table->integer('assigned_emp_id')->nullable();
            $table->enum('assigned_emp_type', ['internal_employee', 'subcontractor', 'subcontractor_employee'])->default('internal_employee');
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->text('description')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('project_management_histories');
    }
}
