<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProjectManagementDacumentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('project_management_dacuments', function (Blueprint $table) {
            $table->id();
            $table->integer('project_management_id')->nullable();
            $table->string('document_name')->nullable();
            $table->text('comment')->nullable();
            $table->string('document_path')->nullable();
            $table->integer('uploaded_by')->nullable();
            $table->enum('uploaded_by_type', ['customer','internal_employee', 'subcontractor', 'subcontractor_employee'])->default('internal_employee');
            $table->string('del')->default('0');
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('project_management_dacuments');
    }
}
