<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_document_signatures', function (Blueprint $table) {
            $table->string('user_type', 50)->nullable()->after('site_id')->comment('Type of signer: subcontractor, external, or internal');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_document_signatures', function (Blueprint $table) {
            $table->dropColumn('user_type');
        });
    }
};
