<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use DB;

class RolesAndPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        // Optionally truncate tables before seeding

        $roles = [
            [
                'id' => 330,
                'title' => 'Admin',
                'code' => 'A-1',
                'del' => '0',
                'created_at' => '2023-11-03 04:34:19',
                'updated_at' => '2023-11-03 04:34:19',
            ],
            [
                'id' => 331,
                'title' => 'HR Manager',
                'code' => 'Hr',
                'del' => '0',
                'created_at' => '2023-11-03 04:34:44',
                'updated_at' => '2023-11-03 04:34:44',
            ],
            [
                'id' => 332,
                'title' => 'Employee',
                'code' => 'emp',
                'del' => '0',
                'created_at' => '2023-11-03 04:34:44',
                'updated_at' => '2023-11-03 06:45:07',
            ],
            [
                'id' => 333,
                'title' => 'Supervisor',
                'code' => 'SPV',
                'del' => '0',
                'created_at' => '2023-11-03 04:34:44',
                'updated_at' => '2023-11-03 06:45:07',
            ]
        ];

        foreach ($roles as $role) {
            DB::table('roles')->updateOrInsert(
                ['id' => $role['id']], // Condition to check for existence
                $role // Data to insert or update
            );
        }





        $modules = [
            ['id' => 1, 'title' => 'Dashboard', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 2, 'title' => 'Employees', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 3, 'title' => 'Clients', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 4, 'title' => 'Sites', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 5, 'title' => 'Projects', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 6, 'title' => 'Leave Management', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 7, 'title' => 'Tier Management', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 8, 'title' => 'Attendance', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 9, 'title' => 'Roster', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 10, 'title' => 'Meetings Manager', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 11, 'title' => 'Super Funds', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 12, 'title' => 'General Settings', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 13, 'title' => 'Permission', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 14, 'title' => 'Inspection Plan', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 15, 'title' => 'File Manager', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 16, 'title' => 'SWMS', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 17, 'title' => 'WHS', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 18, 'title' => 'Incident Report', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],

        ];

        foreach ($modules as $module) {
            DB::table('permissions_modules')->updateOrInsert(
                ['id' => $module['id']], // Condition to check for existence
                $module // Data to insert or update
            );
        }



        // sub modules 

        $subModules = [
            ['id' => 1, 'title' => 'Employee List', 'module_id' => '2', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 2, 'title' => 'Invite Employee List', 'module_id' => '2', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 3, 'title' => 'Registration Setting', 'module_id' => '2', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 4, 'title' => 'Profile', 'module_id' => '2', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 5, 'title' => 'Dashboard', 'module_id' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 6, 'title' => 'Clients', 'module_id' => '3', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 7, 'title' => 'Sites', 'module_id' => '4', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 8, 'title' => 'Projects', 'module_id' => '5', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 9, 'title' => 'Leaves Portal', 'module_id' => '6', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 10, 'title' => 'Public Holiday', 'module_id' => '6', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 11, 'title' => 'Leave Type', 'module_id' => '6', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 12, 'title' => 'Leave Package', 'module_id' => '6', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 13, 'title' => 'Leave Request', 'module_id' => '6', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 14, 'title' => 'Tier List', 'module_id' => '7', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 15, 'title' => 'Tier Package', 'module_id' => '7', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 16, 'title' => 'Attendance', 'module_id' => '8', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 17, 'title' => 'Attendance Request', 'module_id' => '8', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 18, 'title' => 'Attendance Portal', 'module_id' => '8', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 19, 'title' => 'Roster', 'module_id' => '9', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 20, 'title' => 'Meetings Manager', 'module_id' => '10', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 21, 'title' => 'Super Funds', 'module_id' => '11', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 22, 'title' => 'General Settings', 'module_id' => '12', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 23, 'title' => 'Permissions', 'module_id' => '13', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 24, 'title' => 'InspectionList', 'module_id' => '14', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 25, 'title' => 'InspectionSettings', 'module_id' => '14', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 26, 'title' => 'PDF List', 'module_id' => '15', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 27, 'title' => 'Swms List', 'module_id' => '16', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 28, 'title' => 'Swms Settings', 'module_id' => '16', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 29, 'title' => 'WHSList', 'module_id' => '17', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 30, 'title' => 'WHSSettings', 'module_id' => '17', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 31, 'title' => 'Incident Report', 'module_id' => '18', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 32, 'title' => 'Incident Report Setting', 'module_id' => '18', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],


        ];

        foreach ($subModules as $subModule) {
            DB::table('permissions_sub_modules')->updateOrInsert(
                ['id' => $subModule['id']],
                $subModule // Data to insert or update
            );
        }


        $tierPermissions = [
            ['id' => 241, 'tier_id' => '1', 'sub_module_id' => '5', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 242, 'tier_id' => '1', 'sub_module_id' => '1', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 243, 'tier_id' => '1', 'sub_module_id' => '2', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 244, 'tier_id' => '1', 'sub_module_id' => '3', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 245, 'tier_id' => '1', 'sub_module_id' => '4', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 246, 'tier_id' => '1', 'sub_module_id' => '6', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 247, 'tier_id' => '1', 'sub_module_id' => '7', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 248, 'tier_id' => '1', 'sub_module_id' => '8', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 249, 'tier_id' => '1', 'sub_module_id' => '9', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 250, 'tier_id' => '1', 'sub_module_id' => '10', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 251, 'tier_id' => '1', 'sub_module_id' => '11', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 252, 'tier_id' => '1', 'sub_module_id' => '12', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 253, 'tier_id' => '1', 'sub_module_id' => '13', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 254, 'tier_id' => '1', 'sub_module_id' => '14', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 255, 'tier_id' => '1', 'sub_module_id' => '15', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 256, 'tier_id' => '1', 'sub_module_id' => '16', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 257, 'tier_id' => '1', 'sub_module_id' => '17', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 258, 'tier_id' => '1', 'sub_module_id' => '18', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 259, 'tier_id' => '1', 'sub_module_id' => '19', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 260, 'tier_id' => '1', 'sub_module_id' => '20', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 261, 'tier_id' => '1', 'sub_module_id' => '21', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 262, 'tier_id' => '1', 'sub_module_id' => '22', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 263, 'tier_id' => '1', 'sub_module_id' => '23', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 264, 'tier_id' => '1', 'sub_module_id' => '24', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 265, 'tier_id' => '1', 'sub_module_id' => '25', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 266, 'tier_id' => '1', 'sub_module_id' => '26', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 267, 'tier_id' => '1', 'sub_module_id' => '27', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 268, 'tier_id' => '1', 'sub_module_id' => '28', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 268, 'tier_id' => '1', 'sub_module_id' => '29', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 268, 'tier_id' => '1', 'sub_module_id' => '30', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 269, 'tier_id' => '1', 'sub_module_id' => '31', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],
            ['id' => 270, 'tier_id' => '1', 'sub_module_id' => '32', 'view' => '1', 'maintain' => '1', 'del' => '0', 'created_at' => NULL, 'updated_at' => NULL],

        ];

        foreach ($tierPermissions as $permission) {
            DB::table('tier_permissions')->updateOrInsert(
                ['id' => $permission['id']], // Condition to check for existence
                $permission // Data to insert or update
            );
        }
    }
}
