<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\EmpAccess;
use Illuminate\Support\Facades\DB;

class UpdateEmpAccessSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->command->info('Starting EmpAccess table update...');
        
        try {
            // Get total count before update
            $totalRecords = EmpAccess::count();
            $this->command->info("Total records found in emp_access table: {$totalRecords}");
            
            if ($totalRecords === 0) {
                $this->command->warn('No records found in emp_access table. Nothing to update.');
                return;
            }

            // Update all records in emp_access table
            // Set only specific columns to zero, leave other columns unchanged
            $updatedCount = EmpAccess::query()->update([
                'attendance' => 0,
                'timesheet_reminders' => 0,
                'email' => 0,
                'timesheet' => 0,
            ]);

            $this->command->info("✅ Successfully updated {$updatedCount} records in emp_access table.");
            $this->command->info("📝 Columns updated to 0: attendance, timesheet_reminders, email, timesheet");
            $this->command->info("🔒 Other columns remained unchanged");
            
        } catch (\Exception $e) {
            $this->command->error("❌ Error updating emp_access table: " . $e->getMessage());
            throw $e;
        }
    }
}