@php
    use Illuminate\Support\Facades\DB;
    use App\Models\User;

    // Default values
    $logoPath = null;
    $companyName = env('APP_NAME', 'WMS');
    $companyAddress = '';
    $companyCity = '';
    $companyState = '';
    $companyPostCode = '';
    $companyCountry = '';
    $companyPhone = 'Contact Information';
    $companyEmail = '';

    // Get admin settings data
    $admin = User::where('user_type', config('constants.user_types.admin'))->first();
    if ($admin) {
        $settings = DB::table('adminsettings')->where('customer_id', $admin->id)->get();

        // Transform into key-value pairs for easier access
        $settingsData = [];
        foreach ($settings as $setting) {
            $settingsData[$setting->key] = $setting->value;
        }

        // Get logo
        if (isset($settingsData['brand_logo_dark'])) {
            $logoPath = $settingsData['brand_logo_dark'];
        }

        // Get company information
        if (isset($settingsData['company_company_name'])) {
            $companyName = $settingsData['company_company_name'];
        }
        if (isset($settingsData['company_company_address'])) {
            $companyAddress = $settingsData['company_company_address'];
        }
        if (isset($settingsData['company_company_city'])) {
            $companyCity = $settingsData['company_company_city'];
        }
        if (isset($settingsData['company_company_state'])) {
            $companyState = $settingsData['company_company_state'];
        }
        if (isset($settingsData['company_company_post_code'])) {
            $companyPostCode = $settingsData['company_company_post_code'];
        }
        if (isset($settingsData['company_company_country'])) {
            $companyCountry = $settingsData['company_company_country'];
        }
        if (isset($settingsData['company_company_telephone'])) {
            $companyPhone = $settingsData['company_company_telephone'];
        }
        if (isset($settingsData['company_company_email'])) {
          $companyEmail = $settingsData['company_company_email'];
      }
    }
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{{ $subject }}</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">

  @include('Emails.partial.admin-style')
 
</head>
<body>
  <div class="email-template">
  @include('Emails.partial.header', ['logoPath' => $logoPath])
    <div class="email-body">
      <div class="email-body-box-one">
          <div class="email-body-icon-one">
            <img src="{{ url('assets/img/Symbol.png') }}" >
          </div>
          <h2>Welcome to {{ $companyName }}</h2>
          <p class="email-body-box-one-first-p">Thank you for signing up.</p>
      </div>
      <div class="email-body-box-two">
        <div class="email-body-main-text">
          <p>
            Hi <span>{{$name}}</span>,
            <br/><br/>
            Your account has been successfully created. You can now log in to access our services and features.
          </p>
        </div>
        <div class="email-body-details-box">
          <h3>
           Account Details
          </h3>
          <table>
            <tr>
              <td>Name</td>
              <td style="text-align: end;">
                {{$name}}
              </td>
            </tr>
            <tr>
              <td>Email</td>
              <td style="text-align: end;">
                {{ $email }}
              </td>
            </tr>
            <tr>
              <td >Password</td>
              <td style="text-align: end;">
                {{$password}}
              </td>
            </tr>
            <tr>
              <td style="border-bottom: none;padding-bottom:0px;">Workspace</td>
              <td style="text-align: end;border-bottom: none;padding-bottom: 0px;">
              {{ $workspace_name }}
              </td>
            </tr>
          </table>
          <h3 style="margin-top:20px;">
            Account Summary
          </h3>
          <table>
            <tr>
              <td>Account Status</td>
              <td style="text-align: end;">
              Active
              </td>
            </tr>
            <tr>
              <td>Account Type</td>
              <td style="text-align: end;">
              Customer
              </td>
            </tr>
            <tr>
              <td style="border-bottom: none;padding-bottom:0px;">Created Date</td>
              <td style="text-align: end;border-bottom: none;padding-bottom: 0px;">
              {{ date('M d, Y') }}
              </td>
            </tr>
          </table>
        </div>
        <div class="email-alert-box">
          <table>
            <tr>
              <td style="width: 50px;vertical-align: baseline;text-align: start;">
                <img src="{{ url('assets/img/alert-icon.png') }}" alt="">
              </td>
              <td>
                <h3>Quick Access</h3>
                <p>Use the login button below to access your account. Save your login credentials in a secure location for future reference.</p>
              </td>
            </tr>
          </table>
        </div>
        <a href="{{ env('FRONTEND_URL') }}" class="email-body-button">Login to Your Account</a>
        <p class="email-body-thankyou-text">
          If you have any questions or need assistance, feel free to contact our support team.<br/><br/>
          <strong>Important:</strong> Please keep your login credentials secure and do not share them with anyone.
          <br/><br/>
          Thank you,<br/>
          {{ $companyName }} Team
        </p>
      </div>
    </div>
    @include('Emails.partial.admin-footer')
  </div>

</body>
</html>