@php
    use App\Services\CompanyEmailDetails;

    $companyDetails = CompanyEmailDetails::getCompanyEmailDetails();

    // Extract variables for easier use in template
    $logoPath = $companyDetails['logoPath'];
    $companyName = $companyDetails['companyName'];
    $companyAddress = $companyDetails['companyAddress'];
    $companyCity = $companyDetails['companyCity'];
    $companyState = $companyDetails['companyState'];
    $companyPostCode = $companyDetails['companyPostCode'];
    $companyCountry = $companyDetails['companyCountry'];
    $companyPhone = $companyDetails['companyPhone'];
    $companyEmail = $companyDetails['companyEmail'];
    $fullAddress = $companyDetails['companyAddressFull'];

    // Define color theme for this email
    $themeColor = '#22C55E'; // Green
    $themeBackground = 'linear-gradient(135deg, #D1FAE5 0%, #A7F3D0 100%)';
    $themeIcon = '🔑';

    // Helper function to safely get settings

@endphp
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{{ $subject }}</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
  @php
    \Illuminate\Support\Facades\Log::info('OTP Email Template: Before including style partial', [
      'customer_id' => $customer_id ?? 'NULL',
      'email' => $email ?? 'NULL',
      'template_path' => 'Emails.employee-credentials'
    ]);
    
    // Check if the partial file exists
    $stylePartialPath = resource_path('views/Emails/partial/style.blade.php');
    $stylePartialExists = file_exists($stylePartialPath);
    \Illuminate\Support\Facades\Log::info('OTP Email Template: Style partial file check', [
      'path' => $stylePartialPath,
      'exists' => $stylePartialExists,
      'readable' => $stylePartialExists ? is_readable($stylePartialPath) : false
    ]);
  @endphp
  @include('Emails.partial.style', ['customer_id' => $customer_id])
  @php
    \Illuminate\Support\Facades\Log::info('OTP Email Template: After including style partial');
  @endphp
</head>
<body>
  <div class="email-template">
    @include('Emails.partial.header', ['logoPath' => $logoPath])
    <div class="email-body">
      <div class="email-body-box-one">
          <div class="email-body-icon-one">
            <img src="{{ url('assets/img/Symbol.png') }}" >
          </div>
          <h2>Welcome to {{ $companyName }}</h2>
          <p class="email-body-box-one-first-p">Your login credentials are as follows:</p>
      </div>
      <div class="email-body-box-two">
        <div class="email-body-main-text">
          <p>
            Hi <span>{{ $email }}</span>,
            <br/><br/>
            Use the credentials above to login immediately and update your password.
            <br/><br/>
            <strong>Email:</strong> {{ $email }}
            <br/><br/>
            <strong>Password:</strong> {{ $password }}
          </p>
        </div>
        <div class="email-alert-box">
          <table>
            <tr>
              <td style="width: 50px;vertical-align: baseline;text-align: start;">
                <img src="{{ url('assets/img/alert-icon.png') }}" alt="">
              </td>
              <td>
                <h3>Security Notice</h3>
                <p>Your admin has updated your credentials. Please login using these new credentials and change your password immediately after first login for security.</p>
              </td>
            </tr>
          </table>
        </div>
        <p class="email-body-thankyou-text">
        Welcome aboard!<br/>
          {{ $companyName }} Team
        </p>
        <br/>
        @if (env('APP_LINK_APPSTORE') || env('APP_LINK_APPSTORE_Apple'))
            <div class="app-download">
                <div style="display:flex;">
                    @if (env('APP_LINK_APPSTORE'))
                        <a class="store-card" href="{{ env('APP_LINK_APPSTORE') }}" target="_blank"
                            rel="noopener" style="margin-right: 10px; vertical-align: middle;">
                            <span class="store-badge">
                                <img src="https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png"
                                    alt="Get it on Google Play"
                                    style="width: 150px; border: 0; display: block;">
                            </span>
                        </a>
                    @endif
                    @if (env('APP_LINK_APPSTORE_Apple'))
                        <a class="store-card" href="{{ env('APP_LINK_APPSTORE_Apple') }}" target="_blank"
                        rel="noopener" style="margin-right: 10px;margin-top:8px; vertical-align: middle;">
                            <span class="store-badge">
                                <img src="{{ url('assets/img/apple-store.png') }}"
                                    alt="Apple"
                                    style="width: 125px; border: 0; display: block;">
                            </span>
                        </a>
                    @endif
                </div>
            </div>
        @endif
      </div>
    </div>
   
   
    @include('Emails.partial.customer-footer', [
      'logoPath' => $logoPath,
      'fullAddress' => $fullAddress,
      'companyPhone' => $companyPhone,
      'companyEmail' => $companyEmail
    ])
  </div>
  @include('Emails.partial.admin-footer')
</body>
</html>
