@php
use App\Services\CompanyEmailDetails;

// Get company details using global helper function
$companyDetails = CompanyEmailDetails::getCompanyEmailDetails($customer_id);

// Extract variables for easier use in template
$logoPath = $companyDetails['logoPath'];
$companyName = $companyDetails['companyName'];
$companyAddress = $companyDetails['companyAddress'];
$companyCity = $companyDetails['companyCity'];
$companyState = $companyDetails['companyState'];
$companyPostCode = $companyDetails['companyPostCode'];
$companyCountry = $companyDetails['companyCountry'];
$companyPhone = $companyDetails['companyPhone'];
$companyEmail = $companyDetails['companyEmail'];
@endphp

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $subject }}</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap"
        rel="stylesheet">
    <style>
        * {
            padding: 0;
            margin: 0;
            font-family: 'Inter', sans-serif !important;
            box-sizing: border-box;
        }

        body {
            background-color: #f8f9fa;
            padding: 20px 0;
        }

        #email-body {
            min-width: 600px;
            width: 600px;
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            font-family: 'Inter', sans-serif !important;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            overflow: hidden;
        }

        #email-header {
            padding: 18px 25px;
            background: linear-gradient(135deg, #fff 0%, #fff 100%);
            text-align: left;
        }

        #email-header img {
            height: 54px;
            width: auto;
            display: inline-block;
        }

        #email-header h2 {
            color: black;
            margin: 0;
            font-weight: 700;
            font-size: 24px;
        }

        #email-content {
            padding: 15px 18px;
            color: #333333;
        }

        .greeting-section {
            font-size: 14px;
            margin-bottom: 10px;
            color: #6b7280;
        }

        .onboarding-title {
            font-size: 18px;
            font-weight: 700;
            margin-bottom: 12px;
            color: #1f2937;
        }

        .welcome-section {
            background-color: #f0f9ff;
            padding: 8px;
            border-radius: 5px;
            margin-bottom: 10px;
            border-left: 4px solid #22c55e;
        }

        .welcome-section h3 {
            color: #22c55e;
            margin-bottom: 8px;
            font-size: 16px;
        }

        .welcome-section p {
            font-size: 14px;
            margin-bottom: 5px;
        }

        .welcome-section strong {
            color: #22c55e;
        }

        .employee-details {
            background-color: #f9fafb;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 10px;
            border: 1px solid #e5e7eb;
        }

        .employee-details h3 {
            color: #374151;
            margin-bottom: 6px;
            font-size: 14px;
            font-weight: 600;
        }

        .detail-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 12px;
        }

        .detail-table td {
            padding: 3px 5px;
            border-bottom: 1px solid #f3f4f6;
        }

        .detail-table tr:last-child td {
            border-bottom: none;
        }

        .detail-label {
            font-weight: 500;
            color: #4b5563;
            width: 35%;
        }

        .detail-value {
            font-weight: 600;
            color: #1f2937;
            width: 65%;
        }

        .schedule-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 11px;
            margin-top: 6px;
        }

        .schedule-table th {
            background-color: #f3f4f6;
            color: #374151;
            font-weight: 600;
            padding: 4px 3px;
            text-align: left;
            border-bottom: 2px solid #e5e7eb;
            font-size: 10px;
        }

        .schedule-table td {
            padding: 3px;
            border-bottom: 1px solid #f3f4f6;
            vertical-align: top;
            font-size: 10px;
        }

        .schedule-table tr:nth-child(even) {
            background-color: #f9fafb;
        }

        .schedule-table tr:hover {
            background-color: #f0f9ff;
        }

        .important-notice {
            background-color: #fffbeb;
            padding: 10px;
            border-radius: 6px;
            margin-bottom: 12px;
            border: 1px solid #fbbf24;
        }

        .important-notice p {
            color: #92400e;
            margin-bottom: 5px;
        }

        .important-notice strong {
            color: #78350f;
        }

        .email-content-area p {
            font-size: 14px;
            margin-bottom: 15px;
            line-height: 1.6;
        }

        .thank-you {
            font-weight: 600;
            color: #374151;
            margin-top: 25px;
            margin-bottom: 0;
        }

        .login-credentials {
            background-color: #fef3c7;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 8px;
            border: 1px solid #f59e0b;
        }

        .login-credentials h3 {
            color: #d97706;
            margin-bottom: 6px;
            font-size: 14px;
            font-weight: 600;
        }

        .next-steps {
            background-color: #ecfdf5;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 8px;
            border: 1px solid #22c55e;
        }

        .next-steps h3 {
            color: #22c55e;
            margin-bottom: 6px;
            font-size: 14px;
            font-weight: 600;
        }

        .next-steps ul {
            margin-left: 20px;
        }

        .next-steps li {
            font-size: 14px;
            margin-bottom: 8px;
            color: #1f2937;
        }

        .app-download {
            margin-top: 10px;
        }

        .store-card {
            display: inline-block;
            background: #0f172a;
            padding: 0px 10px;
            border-radius: 8px;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15);
        }

        .store-badge {
            display: inline-block;
            line-height: 0;
        }

        .store-caption {
            font-size: 10px;
            color: #6b7280;
            margin-top: 6px;
            text-align: center;
        }

        #email-footer {
            margin-top: 10px;
        }

        #tagline-section {
            background-color: #EDEDED;
            padding: 10px;
            text-align: center;
            font-size: 11px;
            color: #6b7280;
        }

        .small-tagline {
            font-size: 10px;
            color: #6b7280;
            margin-bottom: 3px;
        }

        .big-tagline {
            font-size: 11px;
            color: #374151;
            font-weight: 600;
        }

        .big-tagline a {
            color: #787f83;
            font-weight: 600;
            text-decoration: none;
        }

        .company-details {
            text-align: center;
            padding: 12px;
            background-color: #ffffff;
        }

        .company-title {
            font-size: 12px;
            font-weight: 600;
            color: #374151;
            margin-bottom: 3px;
        }

        .company-address-contact {
            color: #6b7280;
            font-size: 10px;
            line-height: 1.3;
        }

        .footer-logo {
            height: 54px;
            width: auto;
        }
    </style>
</head>

<body>
    <div id="email-body">
        <div id="email-header">
            @if (!empty($logoPath) && file_exists(public_path($logoPath)))
            <img src="{{ url($logoPath) }}" height="54px" width="auto" alt="Logo">
            @else
            <h3>{{ $companyName }}</h3>
            @endif
        </div>

        <div id="email-content">
            <div class="greeting-section">
                Hello, <strong
                    style="font-weight: 700; font-size: 18px; color: #1f2937;">{{ $employee->first_name ?? '' }}
                    {{ $employee->last_name ?? '' }}</strong>
            </div>

            <div class="onboarding-title">
                🎉 Welcome to {{ $companyName }}!
            </div>

            <div class="welcome-section">
                <h3>✅ Registration Complete</h3>
                <p><strong>Status:</strong> Your external employee onboarding has been successfully completed!</p>
                <p><strong>Email:</strong> {{ $employeeCompany->employee_email ?? '' }}</p>
            </div>

            <div class="employee-details">
                <h3>👤 Your Details</h3>
                <table class="detail-table">
                    <tr>
                        <td class="detail-label">Full Name:</td>
                        <td class="detail-value">{{ $employee->first_name ?? '' }} {{ $employee->middle_name ?? '' }}
                            {{ $employee->last_name ?? '' }}
                        </td>
                    </tr>
                    @if (isset($employeeCompany->job_title) && $employeeCompany->job_title)
                    <tr>
                        <td class="detail-label">Job Title:</td>
                        <td class="detail-value">{{ $employeeCompany->job_title }}</td>
                    </tr>
                    @endif

                    @if (isset($workerType->title) && $workerType->title)
                    <tr>
                        <td class="detail-label">Worker Type:</td>
                        <td class="detail-value">{{ $workerType->title }}</td>
                    </tr>
                    @endif


                    <tr>
                        <td class="detail-label">Mobile:</td>
                        <td class="detail-value">{{ $employee->mobile ?? 'N/A' }}</td>
                    </tr>
                    @if (isset($employee->suburb))
                    <tr>
                        <td class="detail-label">Location:</td>
                        <td class="detail-value">{{ $employee->suburb }}, {{ $employee->state ?? '' }}</td>
                    </tr>
                    @endif
                </table>
            </div>

            @if (isset($rosterDetails) && (!empty($rosterDetails['bulk_schedule']) || !empty($rosterDetails['individual_shifts'])))
            <div class="employee-details">
                <h3>📅 Your Work Schedule</h3>

                @if (isset($rosterDetails['bulk_schedule']) && !empty($rosterDetails['bulk_schedule']))
                <!-- Compact Schedule Overview -->
                <div
                    style="background-color: #ecfdf5; padding: 8px; border-radius: 4px; margin-bottom: 8px; border: 1px solid #22c55e;">
                    <h4 style="color: #22c55e; margin-bottom: 4px; font-size: 13px; font-weight: 600;">📋
                        Schedule: {{ $rosterDetails['bulk_schedule']['schedule_period_start'] }} to
                        {{ $rosterDetails['bulk_schedule']['schedule_period_end'] }}
                    </h4>
                    <p style="font-size: 11px; margin: 0; color: #374151;">
                        <strong>{{ $rosterDetails['bulk_schedule']['working_days'] }}</strong> •
                        {{ $rosterDetails['bulk_schedule']['daily_start_time'] }}-{{ $rosterDetails['bulk_schedule']['daily_end_time'] }}
                        @if (isset($rosterDetails['bulk_schedule']['daily_break_minutes']) &&
                        $rosterDetails['bulk_schedule']['daily_break_minutes'] > 0)
                        • {{ $rosterDetails['bulk_schedule']['daily_break_minutes'] }}min break
                        @endif
                        @if (isset($rosterDetails['bulk_schedule']['shift_notes']) && !empty($rosterDetails['bulk_schedule']['shift_notes']))
                        • {{ $rosterDetails['bulk_schedule']['shift_notes'] }}
                        @endif
                    </p>
                </div>
                @endif

                @if (isset($rosterDetails['individual_shifts']) && !empty($rosterDetails['individual_shifts']))
                <!-- Compact Shifts List - Next 3 only -->
                <h4 style="color: #374151; margin-bottom: 4px; font-size: 13px; font-weight: 600;">📋 Next 3
                    Shifts</h4>

                <table class="schedule-table">
                    <thead>
                        <tr>
                            <th>📅 Date</th>
                            <th>⏰ Time</th>
                            <th>📝 Details</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach (array_slice($rosterDetails['individual_shifts'], 0, 3) as $index => $roster)
                        <tr>
                            <td><strong
                                    style="font-size: 10px;">{{ $roster['schedule_date'] }}</strong><br><small
                                    style="font-size: 9px;">{{ $roster['day_name'] }}</small></td>
                            <td style="font-size: 10px;">
                                {{ $roster['start_time'] }}-{{ $roster['end_time'] }}
                            </td>
                            <td style="font-size: 9px;">
                                @if (isset($roster['working_hours']) && $roster['working_hours'] > 0)
                                {{ number_format($roster['working_hours'] / 60, 1) }}h
                                @endif
                                @if (isset($roster['break_minutes']) && $roster['break_minutes'] > 0)
                                • {{ $roster['break_minutes'] }}min break
                                @endif
                                @if (isset($roster['shift_notes']) && !empty($roster['shift_notes']))
                                <br>{{ $roster['shift_notes'] }}
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                @if (count($rosterDetails['individual_shifts']) > 3)
                <p style="font-size: 9px; color: #6b7280; margin-top: 3px; margin-bottom: 0;">
                    <em>+ {{ count($rosterDetails['individual_shifts']) - 3 }} more in your account</em>
                </p>
                @endif
                @endif
            </div>
            @endif

            @if (isset($password))
            <div class="login-credentials">
                <h3>🔐 Your Login Credentials</h3>
                <table class="detail-table">
                    <tr>
                        <td class="detail-label">Email:</td>
                        <td class="detail-value">{{ $employeeCompany->employee_email ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <td class="detail-label">Password:</td>
                        <td class="detail-value"
                            style="font-family: monospace; background-color: #f3f4f6; padding: 4px 8px; border-radius: 4px;">
                            {{ $password }}
                        </td>
                    </tr>
                </table>
            </div>
            @endif

            @if (env('APP_LINK_APPSTORE') || env('APP_LINK_APPSTORE_Apple'))
                <div class="app-download">
                    <div style="text-align: center;">
                        @if (env('APP_LINK_APPSTORE'))
                            <a class="store-card" href="{{ env('APP_LINK_APPSTORE') }}" target="_blank"
                                rel="noopener" style="margin-right: 10px; vertical-align: middle;">
                                <span class="store-badge">
                                    <img src="https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png"
                                        alt="Get it on Google Play"
                                        style="height: 42px; width: auto; border: 0; display: block;">
                                </span>
                            </a>
                        @endif
                        @if (env('APP_LINK_APPSTORE_Apple'))
                            <a class="store-card" href="{{ env('APP_LINK_APPSTORE_Apple') }}" target="_blank"
                                rel="noopener"
                                style="background: #000000; padding: 8px 12px; border-radius: 8px; display: inline-block; vertical-align: middle; text-decoration: none; height: 48px; box-sizing: border-box; line-height: 0;">
                                <table role="presentation" cellpadding="0" cellspacing="0" border="0"
                                    style="margin: 0; padding: 0; height: 100%;">
                                    <tr style="height: 100%;">
                                        <td style="padding: 0 6px 0 0; vertical-align: middle;">
                                            <img src="https://img.icons8.com/?size=100&id=30840&format=png&color=FFFFFF"
                                                alt="Apple"
                                                style="width: 18px; height: 18px; display: block; border: 0;">
                                        </td>
                                        <td style="padding: 0; vertical-align: middle;">
                                            <div
                                                style="color: #FFFFFF; font-size: 7px; letter-spacing: 0.5px; line-height: 9px; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Arial, sans-serif; font-weight: 400; white-space: nowrap;">
                                                Download on the</div>
                                            <div
                                                style="color: #FFFFFF; font-size: 12px; line-height: 14px; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Arial, sans-serif; font-weight: 600; margin-top: 1px; white-space: nowrap;">
                                                App Store</div>
                                        </td>
                                    </tr>
                                </table>
                            </a>
                        @endif
                    </div>
                    <div class="store-caption">Tap to download our mobile app</div>
                </div>
            @endif

            <div class="next-steps">
                <h3>📋 Important • Next Steps</h3>
                <div style="font-size: 11px; line-height: 1.3;">
                    @if(env('APP_LINK_APPSTORE'))
                    <p style="margin: 0 0 5px 0;"><strong>📱 Download App:</strong> Install the mobile app using the Google Play Store badge above for easy access</p>
                    @endif
                    @if (isset($rosterDetails) && !empty($rosterDetails))
                    <p style="margin: 0 0 5px 0;"><strong>📅 Schedule:</strong> Review your work schedule and arrive
                        on time</p>
                    @endif
                    <p style="margin: 0 0 5px 0;"><strong>📧 Updates:</strong> Keep contact info updated & check emails
                        regularly</p>
                    <p style="margin: 0 0 8px 0;"><strong>❓ Questions:</strong> Contact HR for employment or schedule
                        questions</p>

                    <div
                        style="background-color: #fffbeb; padding: 6px; border-radius: 3px; border: 1px solid #fbbf24; margin-bottom: 8px;">
                        <p style="color: #92400e; font-size: 10px; margin: 0;">
                            <strong>🔒 Save this email</strong> • Your external employee onboarding is complete with
                            login access confirmed.
                        </p>
                    </div>

                    <p style="font-size: 12px; margin: 0; text-align: center;">
                        <strong>Welcome to {{ $companyName }}!</strong><br>
                        <span style="color: #6b7280; font-size: 10px;">Best regards, {{ $companyName }} Team</span>
                    </p>
                </div>
            </div>
        </div>

        <div id="email-footer">
            <div id="tagline-section">
                <p class="small-tagline">This is an auto-generated email. Please do not reply.</p>
                <p class="big-tagline">For questions or support, contact
                    <a href="mailto:{{ $companyEmail }}">{{ $companyEmail }}</a>
                </p>
            </div>

            <div class="company-details">
                @if (!empty($logoPath) && file_exists(public_path($logoPath)))
                <img src="{{ url($logoPath) }}" class="footer-logo" alt="Logo">
                @endif
                <div class="company-title">{{ $companyName }}</div>
                <div class="company-address-contact">
                    @if ($companyAddress)
                    {{ $companyAddress }}
                    @endif
                    @if ($companyCity || $companyState || $companyPostCode)
                    @if ($companyAddress)
                    ,
                    @endif
                    {{ $companyCity }}{{ $companyState ? ', ' . $companyState : '' }}{{ $companyPostCode ? ' ' . $companyPostCode : '' }}
                    @endif
                    @if ($companyCountry)
                    @if ($companyAddress || $companyCity || $companyState || $companyPostCode)
                    ,
                    @endif{{ $companyCountry }}
                    @endif
                    <br>
                    Call: {{ $companyPhone }}
                </div>
            </div>
        </div>
    </div>
</body>

</html>