@php
    use App\Services\CompanyEmailDetails;

    // Get company details using global helper function
    $customer_id = $customer_id ?? null;
   $companyDetails = CompanyEmailDetails::getCompanyEmailDetails($customer_id);
    // Extract variables for easier use in template
    $logoPath = $companyDetails['logoPath'];
    $companyName = $companyDetails['companyName'];
    $companyAddress = $companyDetails['companyAddress'];
    $companyCity = $companyDetails['companyCity'];
    $companyState = $companyDetails['companyState'];
    $companyPostCode = $companyDetails['companyPostCode'];
    $companyCountry = $companyDetails['companyCountry'];
    $companyPhone = $companyDetails['companyPhone'];
    $companyEmail = $companyDetails['companyEmail'];
    $fullAddress = $companyDetails['companyAddressFull'];
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{{ $subject }}</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">

  @include('Emails.partial.style', ['customer_id' => $customer_id])
 
</head>
<body>
  <div class="email-template">
  @include('Emails.partial.header', ['logoPath' => $logoPath])
    <div class="email-body">
      <div class="email-body-box-one">
        @if($ticket_details['Status'] == 'Approved')
          <div class="email-body-icon-one">
          <img src="{{ url('assets/img/Symbol-4.png') }}" >
          </div>
          @elseif($ticket_details['Status'] == 'Rejected')
          <div class="email-body-icon-one" style="background-color: #DC2626;padding:18px 0px 12px !important;">
          <img src="{{ url('assets/img/Symbol-6.png') }}" >
          </div>
          @else
          <div class="email-body-icon-one">
          <img src="{{ url('assets/img/Symbol-4.png') }}" >
          </div>
          @endif
          <h2>
            @if($ticket_details['Status'] == 'Approved')
              Leave Request Approved
            @elseif($ticket_details['Status'] == 'Rejected')
              Leave Request Rejected
            @else
              Leave Request Submitted
            @endif
          </h2>
          <p class="email-body-box-one-first-p">
            @if($ticket_details['Status'] == 'Approved')
              Your leave request has been approved.
            @elseif($ticket_details['Status'] == 'Rejected')
              Your leave request has been rejected.
            @else
              A new leave request has been submitted.
            @endif
          </p>
      </div>
      <div class="email-body-box-two">
        <div class="email-body-main-text">
          <p>
            Hi <span>{{ $employeeName ?? 'Team Member' }}</span>,
            <br/><br/>
            @if($ticket_details['Status'] == 'Approved')
              Your leave request has been approved. Please review the details below:
            @elseif($ticket_details['Status'] == 'Rejected')
              Your leave request has been rejected. Please review the details below:
            @else
              A new leave request has been submitted. Please review the details below:
            @endif
          </p>
        </div>
        <div class="email-body-details-box">
          <h3>
          Leave Details
          </h3>
          <table>
            @if (isset($ticket_details) && is_array($ticket_details))
              @foreach ($ticket_details as $key => $value)
                @if ($key == 'Reason')
                  <tr>
                    <td colspan="2" style="border-bottom: none;padding-bottom:0px;">{{ $key }}</td>
                  </tr>
                  <tr>
                    <td colspan="2" style="border-bottom: none;padding-bottom:0px;">{{ $value }}</td>
                  </tr>
                @else
                  <tr>
                    <td>{{ $key }}</td>
                    <td style="text-align: end;">
                      @if ($key == 'Status')
                        <span class="status-badge">{{ $value }}</span>
                      @else
                        {{ $value }}
                      @endif
                    </td>
                  </tr>
                @endif
              @endforeach
            @else
              @if(isset($request_id))
              <tr>
                <td>Request ID</td>
                <td style="text-align: end;">{{ $request_id ?? 'N/A' }}</td>
              </tr>
              @endif
              <tr>
                <td>Leave Type</td>
                <td style="text-align: end;">{{ $leave_type ?? $leavePackageName ?? 'N/A' }}</td>
              </tr>
              <tr>
                <td>Start Date</td>
                <td style="text-align: end;">{{ $start_date ?? $startDate ?? 'N/A' }}</td>
              </tr>
              <tr>
                <td>End Date</td>
                <td style="text-align: end;">{{ $end_date ?? $endDate ?? 'N/A' }}</td>
              </tr>
              @if(isset($reason) && $reason)
              <tr>
                <td colspan="2" style="border-bottom: none;padding-bottom:0px;">Reason</td>
              </tr>
              <tr>
                <td colspan="2" style="border-bottom: none;padding-bottom:0px;">{{ $reason }}</td>
              </tr>
              @endif
            @endif
          </table>
        </div>
        <p class="email-body-thankyou-text">
        If you have any questions or need further information, please contact your manager or HR
        department.
          <br/><br/>
          Best regards,<br/>
          {{ $companyName }} Team
        </p>
      </div>
    </div>
    @include('Emails.partial.customer-footer', [
      'logoPath' => $logoPath,
      'fullAddress' => $fullAddress,
      'companyPhone' => $companyPhone,
      'companyEmail' => $companyEmail
    ])
  </div>
  @include('Emails.partial.admin-footer')

</body>
</html>
