@php
   use App\Services\CompanyEmailDetails;
 
   // Ensure customer_id is available
   $customer_id = $customer_id ?? null;
   $companyDetails = CompanyEmailDetails::getCompanyEmailDetails($customer_id);
   
    // Extract variables for easier use in template
    $logoPath = $companyDetails['logoPath'];
    $companyName = $companyDetails['companyName'];
    $companyAddress = $companyDetails['companyAddress'];
    $companyCity = $companyDetails['companyCity'];
    $companyState = $companyDetails['companyState'];
    $companyPostCode = $companyDetails['companyPostCode'];
    $companyCountry = $companyDetails['companyCountry'];
    $companyPhone = $companyDetails['companyPhone'];
    $companyEmail = $companyDetails['companyEmail'];
 
 
  // Format full address
  $fullAddress = $companyAddress;
  if (!empty($companyCity)) {
      $fullAddress .= ', ' . $companyCity;
  }
  if (!empty($companyState)) {
      $fullAddress .= ', ' . $companyState;
  }
  if (!empty($companyPostCode)) {
      $fullAddress .= ' ' . $companyPostCode;
  }
  if (!empty($companyCountry)) {
      $fullAddress .= ', ' . $companyCountry;
  }
@endphp
 
 
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{{ $subject }}</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
  @php
    \Illuminate\Support\Facades\Log::info('OTP Email Template: Before including style partial', [
      'customer_id' => $customer_id ?? 'NULL',
      'email' => $email ?? 'NULL',
      'template_path' => 'Emails.otp-email'
    ]);
    
    // Check if the partial file exists
    $stylePartialPath = resource_path('views/Emails/partial/style.blade.php');
    $stylePartialExists = file_exists($stylePartialPath);
    \Illuminate\Support\Facades\Log::info('OTP Email Template: Style partial file check', [
      'path' => $stylePartialPath,
      'exists' => $stylePartialExists,
      'readable' => $stylePartialExists ? is_readable($stylePartialPath) : false
    ]);
  @endphp
  @include('Emails.partial.style', ['customer_id' => $customer_id])
  @php
    \Illuminate\Support\Facades\Log::info('OTP Email Template: After including style partial');
  @endphp
</head>
<body>
  <div class="email-template">
    @include('Emails.partial.header', ['logoPath' => $logoPath])
    <div class="email-body">
      <div class="email-body-box-one">
          <div class="email-body-icon-one">
            <img src="{{ url('assets/img/Symbol.png') }}" >
          </div>
          <h2>Password Reset Verification</h2>
          <p class="email-body-box-one-first-p">You requested a password reset</p>
          <p class="email-body-box-one-expires-in">
            <span>
             <img src="{{ url('assets/img/Symbol-2.png') }}" alt="Clock Icon">
            </span>
            Expires in 5 minutes
          </p>
      </div>
      <div class="email-body-box-two">
        <div class="email-body-main-text">
          <p>
            Hi <span>{{ $email }}</span>,
            <br/><br/>
            Please use the following OTP (One-Time Password) to complete your password reset process:
          </p>
        </div>
        <span class="email-body-button">{{ $otp_code }}</span>
        <div class="email-alert-box">
          <table>
            <tr>
              <td style="width: 50px;vertical-align: baseline;text-align: start;">
                <img src="{{ url('assets/img/alert-icon.png') }}" alt="">
              </td>
              <td>
                <h3>Security Notice</h3>
                <p>Do not share your OTP. If you did not request a password reset, ignore this email and secure your account.</p>
              </td>
            </tr>
          </table>
        </div>
        <p class="email-body-thankyou-text">
          If you're having trouble with the password reset process or have any questions, please contact our support team for assistance.
          <br/><br/>
          Thank you,<br/>
          {{ $companyName }} Team
        </p>
      </div>
    </div>
   
   
    @include('Emails.partial.customer-footer', [
      'logoPath' => $logoPath,
      'fullAddress' => $fullAddress,
      'companyPhone' => $companyPhone,
      'companyEmail' => $companyEmail
    ])
  </div>
  @include('Emails.partial.admin-footer')
</body>
</html>
 