@php
use App\Services\CompanyEmailDetails;

// Get company details using global helper function
$companyDetails = CompanyEmailDetails::getCompanyEmailDetails($customer_id ?? null, $workspace_id ?? null);

// Extract variables for easier use in template
$logoPath = $companyDetails['logoPath'];
$companyName = $companyDetails['companyName'];
$companyAddress = $companyDetails['companyAddress'];
$companyCity = $companyDetails['companyCity'];
$companyState = $companyDetails['companyState'];
$companyPostCode = $companyDetails['companyPostCode'];
$companyCountry = $companyDetails['companyCountry'];
$companyPhone = $companyDetails['companyPhone'];
$companyEmail = $companyDetails['companyEmail'];
@endphp

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $subject }}</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap"
        rel="stylesheet">
    <style>
        * {
            padding: 0;
            margin: 0;
            font-family: 'Inter', sans-serif !important;
            box-sizing: border-box;
        }

        body {
            background-color: #f8f9fa;
            padding: 20px 0;
        }

        #email-body {
            min-width: 600px;
            width: 600px;
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            font-family: 'Inter', sans-serif !important;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            overflow: hidden;
        }

        #email-header {
            padding: 18px 25px;
            background: linear-gradient(135deg, #fff 0%, #fff 100%);
            text-align: left;
        }

        #email-header img {
            height: 54px;
            width: auto;
            display: inline-block;
        }

        #email-header h3 {
            color: black;
            margin: 0;
            font-weight: 700;
            font-size: 24px;
        }

        #email-content {
            padding: 15px 18px;
            color: #333333;
        }

        .greeting-section {
            font-size: 14px;
            margin-bottom: 10px;
            color: #6b7280;
        }

        .notification-title {
            font-size: 18px;
            font-weight: 700;
            margin-bottom: 12px;
            color: #1f2937;
        }

        .welcome-section {
            background-color: #eff6ff;
            padding: 8px;
            border-radius: 5px;
            margin-bottom: 10px;
            border-left: 4px solid #3b82f6;
        }

        .welcome-section h3 {
            color: #3b82f6;
            margin-bottom: 8px;
            font-size: 16px;
        }

        .welcome-section p {
            font-size: 14px;
            margin-bottom: 5px;
        }

        .welcome-section strong {
            color: #3b82f6;
        }

        .projects-details {
            background-color: #f9fafb;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 10px;
            border: 1px solid #e5e7eb;
        }

        .projects-details h3 {
            color: #374151;
            margin-bottom: 6px;
            font-size: 14px;
            font-weight: 600;
        }

        .project-item {
            padding: 8px;
            background: #ffffff;
            border: 1px solid #e5e7eb;
            border-radius: 4px;
            margin-bottom: 6px;
            font-size: 13px;
            color: #374151;
            font-weight: 500;
        }

        .project-item:last-child {
            margin-bottom: 0;
        }

        .project-item::before {
            content: '✓';
            color: #3b82f6;
            font-weight: 700;
            margin-right: 8px;
        }

        .email-content-area p {
            font-size: 14px;
            margin-bottom: 15px;
            line-height: 1.6;
        }

        .thank-you {
            font-weight: 600;
            color: #374151;
            margin-top: 25px;
            margin-bottom: 0;
        }

        .next-steps {
            background-color: #ecfdf5;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 8px;
            border: 1px solid #22c55e;
        }

        .next-steps h3 {
            color: #22c55e;
            margin-bottom: 6px;
            font-size: 14px;
            font-weight: 600;
        }

        .next-steps ul {
            margin-left: 20px;
        }

        .next-steps li {
            font-size: 14px;
            margin-bottom: 8px;
            color: #1f2937;
        }

        .app-download {
            margin-top: 10px;
        }

        .store-card {
            display: inline-block;
            background: #0f172a;
            padding: 0px 10px;
            border-radius: 8px;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15);
        }

        .store-badge {
            display: inline-block;
            line-height: 0;
        }

        .store-caption {
            font-size: 10px;
            color: #6b7280;
            margin-top: 6px;
            text-align: center;
        }

        #email-footer {
            margin-top: 10px;
        }

        #tagline-section {
            background-color: #EDEDED;
            padding: 10px;
            text-align: center;
            font-size: 11px;
            color: #6b7280;
        }

        .small-tagline {
            font-size: 10px;
            color: #6b7280;
            margin-bottom: 3px;
        }

        .big-tagline {
            font-size: 11px;
            color: #374151;
            font-weight: 600;
        }

        .big-tagline a {
            color: #787f83;
            font-weight: 600;
            text-decoration: none;
        }

        .company-details {
            text-align: center;
            padding: 12px;
            background-color: #ffffff;
        }

        .company-title {
            font-size: 12px;
            font-weight: 600;
            color: #374151;
            margin-bottom: 3px;
        }

        .company-address-contact {
            color: #6b7280;
            font-size: 10px;
            line-height: 1.3;
        }

        .footer-logo {
            height: 54px;
            width: auto;
        }
    </style>
</head>

<body>
    <div id="email-body">
        <div id="email-header">
            @if (!empty($logoPath) && file_exists(public_path($logoPath)))
            <img src="{{ url($logoPath) }}" height="54px" width="auto" alt="Logo">
            @else
            <h3>{{ $companyName }}</h3>
            @endif
        </div>

        <div id="email-content">
            <div class="greeting-section">
                Hello, <strong
                    style="font-weight: 700; font-size: 18px; color: #1f2937;">{{ $employee_name }}</strong>
            </div>

            <div class="notification-title">
                📋 Project Assignment Notification
            </div>

            <div class="welcome-section">
                <h3>✅ New Projects Assigned</h3>
                <p><strong>Status:</strong> You have been assigned to new project(s) by {{ $subcontractor_name ?? 'your subcontractor' }}.</p>
                <p><strong>Action Required:</strong> Please review the assigned projects below and access them through your account.</p>
            </div>

            <div class="projects-details">
                <h3>📁 Newly Assigned Projects</h3>
                @if (!empty($project_names) && count($project_names) > 0)
                    @foreach ($project_names as $projectName)
                        <div class="project-item">{{ $projectName }}</div>
                    @endforeach
                @else
                    <div class="project-item">No projects assigned</div>
                @endif
            </div>

            @if (env('APP_LINK_APPSTORE') || env('APP_LINK_APPSTORE_Apple'))
                <div class="app-download">
                    <div style="text-align: center;">
                        @if (env('APP_LINK_APPSTORE'))
                            <a class="store-card" href="{{ env('APP_LINK_APPSTORE') }}" target="_blank"
                                rel="noopener" style="margin-right: 10px; vertical-align: middle;">
                                <span class="store-badge">
                                    <img src="https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png"
                                        alt="Get it on Google Play"
                                        style="height: 42px; width: auto; border: 0; display: block;">
                                </span>
                            </a>
                        @endif
                        @if (env('APP_LINK_APPSTORE_Apple'))
                            <a class="store-card" href="{{ env('APP_LINK_APPSTORE_Apple') }}" target="_blank"
                                rel="noopener"
                                style="background: #000000; padding: 8px 12px; border-radius: 8px; display: inline-block; vertical-align: middle; text-decoration: none; height: 48px; box-sizing: border-box; line-height: 0;">
                                <table role="presentation" cellpadding="0" cellspacing="0" border="0"
                                    style="margin: 0; padding: 0; height: 100%;">
                                    <tr style="height: 100%;">
                                        <td style="padding: 0 6px 0 0; vertical-align: middle;">
                                            <img src="https://img.icons8.com/?size=100&id=30840&format=png&color=FFFFFF"
                                                alt="Apple"
                                                style="width: 18px; height: 18px; display: block; border: 0;">
                                        </td>
                                        <td style="padding: 0; vertical-align: middle;">
                                            <div
                                                style="color: #FFFFFF; font-size: 7px; letter-spacing: 0.5px; line-height: 9px; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Arial, sans-serif; font-weight: 400; white-space: nowrap;">
                                                Download on the</div>
                                            <div
                                                style="color: #FFFFFF; font-size: 12px; line-height: 14px; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Arial, sans-serif; font-weight: 600; margin-top: 1px; white-space: nowrap;">
                                                App Store</div>
                                        </td>
                                    </tr>
                                </table>
                            </a>
                        @endif
                    </div>
                    <div class="store-caption">Tap to download our mobile app</div>
                </div>
            @endif

            <div class="next-steps">
                <h3>📋 Important • Next Steps</h3>
                <div style="font-size: 11px; line-height: 1.3;">
                    @if(env('APP_LINK_APPSTORE'))
                    <p style="margin: 0 0 5px 0;"><strong>📱 Download App:</strong> Install the mobile app using the badges above for easy access to your projects</p>
                    @endif
                    <p style="margin: 0 0 5px 0;"><strong>🔐 Login:</strong> Access your account to view project details and start working</p>
                    <p style="margin: 0 0 5px 0;"><strong>📧 Updates:</strong> Check your email regularly for project updates and notifications</p>
                    <p style="margin: 0 0 8px 0;"><strong>❓ Questions:</strong> Contact {{ $subcontractor_name ?? $companyName }} for any project-related questions</p>

                    <div
                        style="background-color: #fffbeb; padding: 6px; border-radius: 3px; border: 1px solid #fbbf24; margin-bottom: 8px;">
                        <p style="color: #92400e; font-size: 10px; margin: 0;">
                            <strong>💡 Tip:</strong> You can now access these projects through your account. Log in to view project details and start working.
                        </p>
                    </div>

                    <p style="font-size: 12px; margin: 0; text-align: center;">
                        <strong>Best regards,</strong><br>
                        <span style="color: #6b7280; font-size: 10px;">{{ $subcontractor_name ?? $companyName }} Team</span>
                    </p>
                </div>
            </div>
        </div>

        <div id="email-footer">
            <div id="tagline-section">
                <p class="small-tagline">This is an auto-generated email. Please do not reply.</p>
                <p class="big-tagline">For questions or support, contact
                    <a href="mailto:{{ $companyEmail }}">{{ $companyEmail }}</a>
                </p>
            </div>

            <div class="company-details">
                @if (!empty($logoPath) && file_exists(public_path($logoPath)))
                <img src="{{ url($logoPath) }}" class="footer-logo" alt="Logo">
                @endif
                <div class="company-title">{{ $companyName }}</div>
                <div class="company-address-contact">
                    @if ($companyAddress)
                    {{ $companyAddress }}
                    @endif
                    @if ($companyCity || $companyState || $companyPostCode)
                    @if ($companyAddress)
                    ,
                    @endif
                    {{ $companyCity }}{{ $companyState ? ', ' . $companyState : '' }}{{ $companyPostCode ? ' ' . $companyPostCode : '' }}
                    @endif
                    @if ($companyCountry)
                    @if ($companyAddress || $companyCity || $companyState || $companyPostCode)
                    ,
                    @endif{{ $companyCountry }}
                    @endif
                    <br>
                    Call: {{ $companyPhone }}
                </div>
            </div>
        </div>
    </div>
</body>

</html>
