@php
  use App\General\SettingsClass;
  use Illuminate\Support\Facades\DB;
  use Illuminate\Support\Facades\Route;
  use Illuminate\Support\Facades\Config;
  use App\Models\User;
  
  // Email type configuration
  $emailTypes = [
    'referral_signup_user' => [
      'subject' => 'Your Referral Request is Pending Approval',
      'status_text' => 'Pending Approval',
      'color' => '#f59e0b', // Amber
      'background' => 'linear-gradient(135deg, #fef3c7 0%, #fde68a 100%)',
      'icon' => '⏳',
      'message' => 'Thank you for your interest in becoming a referral partner! Your application is currently under review.',
      'action_required' => false,
      'action_message' => ''
    ],
    'referral_signup_admin' => [
      'subject' => 'New Referral Signup Request',
      'status_text' => 'New Request',
      'color' => '#3b82f6', // Blue
      'background' => 'linear-gradient(135deg, #dbeafe 0%, #bfdbfe 100%)',
      'icon' => '🔔',
      'message' => 'A new referral partner has signed up and is waiting for your approval.',
      'action_required' => true,
      'action_message' => 'Please review and approve/reject this application.'
    ],
    'referral_approved' => [
      'subject' => 'Referral Partnership Approved!',
      'status_text' => 'Approved',
      'color' => '#059669', // Green
      'background' => 'linear-gradient(135deg, #d1fae5 0%, #a7f3d0 100%)',
      'icon' => '🎉',
      'message' => 'Congratulations! Your referral partnership has been approved and you can now start earning commissions.',
      'action_required' => true,
      'action_message' => 'Access your dashboard to start referring customers!'
    ]
  ];

  // Get email type configuration
  $emailType = $emailTypes[$email_type ?? 'referral_signup_user'] ?? $emailTypes['referral_signup_user'];
  
  $logoPath = null;
  $companyName = env('APP_NAME', 'WMS');
  $companyAddress = '';
  $companyCity = '';
  $companyState = '';
  $companyPostCode = '';
  $companyCountry = '';
  $companyPhone = 'Contact Information';
  $companyEmail = env('EMAIL_ADDRESS', 'support@example.com');
  
  // Get admin settings data
  $admin = User::where('user_type', config('constants.user_types.admin'))->first();
  if ($admin) {
    $adminSettings = DB::table('adminsettings')
      ->where('customer_id', $admin->id)
      ->whereIn('key', [
        'company_logo',
        'company_name',
        'company_address',
        'company_city',
        'company_state',
        'company_post_code',
        'company_country',
        'company_phone',
        'company_email'
      ])
      ->pluck('value', 'key')
      ->toArray();
    
    $logoPath = $adminSettings['company_logo'] ?? null;
    $companyName = $adminSettings['company_name'] ?? $companyName;
    $companyAddress = $adminSettings['company_address'] ?? $companyAddress;
    $companyCity = $adminSettings['company_city'] ?? $companyCity;
    $companyState = $adminSettings['company_state'] ?? $companyState;
    $companyPostCode = $adminSettings['company_post_code'] ?? $companyPostCode;
    $companyCountry = $adminSettings['company_country'] ?? $companyCountry;
    $companyPhone = $adminSettings['company_phone'] ?? $companyPhone;
    $companyEmail = $adminSettings['company_email'] ?? $companyEmail;
  }
  
  $fullAddress = trim(implode(', ', array_filter([
    $companyAddress,
    $companyCity,
    $companyState,
    $companyPostCode,
    $companyCountry
  ])));
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{{ $emailType['subject'] }}</title>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
  <style>
    * {
      padding: 0;
      margin: 0;
      font-family: 'Inter', sans-serif !important;
      box-sizing: border-box;
    }
    
    body {
      background-color: #f8f9fa;
      padding: 20px 0;
    }
    
    #email-body {
      min-width: 600px;
      width: 600px;
      max-width: 600px;
      margin: 0 auto;
      background-color: #ffffff;
      font-family: 'Inter', sans-serif !important;
      box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
      border-radius: 8px;
      overflow: hidden;
    }
    
    #email-header {
      padding: 18px 25px;
      background: linear-gradient(135deg, #fff 0%, #fff 100%);
      text-align: left;
      position: relative;
    }
    
    #email-header::after {
      content: '';
      position: absolute;
      top: 0;
      right: 0;
      width: 100px;
      height: 100%;
      background: rgba(255, 255, 255, 0.1);
      transform: skew(-15deg);
      transform-origin: top right;
    }
    
    #email-header img {
      height: 54px;
      width: auto;
      display: inline-block;
    }
    
    #email-header h2 {
      color: white;
      margin: 0;
      font-weight: 700;
      font-size: 24px;
      text-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
    }
    
    #email-content {
      padding: 42px 34px;
      color: #333333;
    }
    
    .greeting-section {
      font-size: 14px;
      margin-bottom: 18px;
      color: #6b7280;
    }
    
    .greeting-section strong {
      color: #1f2937;
      font-weight: 600;
    }
    
        .notification-title {
            font-size: 22px;
            font-weight: 700;
            margin-bottom: 20px;
            color: #1f2937;
            display: flex;
            align-items: center;
            gap: 10px;
        }
    
    .notification-title::before {
      content: "{{ $emailType['icon'] }}";
      font-size: 24px;
    }
    
    .alert-box {
      background-color: #f0f9ff;
      padding: 15px;
      border-radius: 8px;
      margin-bottom: 20px;
      border-left: 4px solid #22c55e;
    }
    
    .alert-box p {
      margin: 0;
      font-size: 14px;
      color: #22c55e;
      font-weight: 500;
    }
    
    .email-content-area {
      margin-bottom: 25px;
      line-height: 1.6;
      color: #4b5563;
    }
    
    .email-content-area p {
      margin-bottom: 15px;
      font-size: 14px;
    }
    
    .info-card {
      background-color: #f9fafb;
      padding: 20px;
      border-radius: 8px;
      margin-bottom: 20px;
      border: 1px solid #e5e7eb;
    }
    
    .info-card h3 {
      color: #374151;
      margin-bottom: 15px;
      font-size: 16px;
      font-weight: 600;
    }
    
    .info-card p {
      font-size: 14px;
      margin-bottom: 5px;
    }

    .info-card strong {
      color: #22c55e;
    }
    
    .status-badge {
      display: inline-block;
      padding: 4px 12px;
      background-color: #22c55e;
      color: white;
      border-radius: 4px;
      font-size: 12px;
      font-weight: 600;
      text-transform: uppercase;
    }
    
    .action-button {
      display: inline-block;
      background-color: #22C55E;
      color: white;
      text-decoration: none;
      padding: 12px 24px;
      border-radius: 8px;
      font-weight: 600;
      margin: 15px 0;
      font-size: 14px;
    }

    .action-button:hover {
      background-color: #16a34a;
    }
    
    .login-button {
      display: inline-block;
      background-color: #22C55E;
      color: white;
      text-decoration: none;
      padding: 12px 24px;
      border-radius: 8px;
      font-weight: 600;
      margin: 15px 0;
      font-size: 14px;
    }

    .login-button:hover {
      background-color: #16a34a;
    }
    
    .divider {
      height: 1px;
      background: #e5e7eb;
      margin: 25px 0;
    }
    
    .footer-message {
      background-color: #fffbeb;
      padding: 15px;
      border-radius: 8px;
      margin-bottom: 20px;
      border: 1px solid #fbbf24;
    }
    
    .footer-message p {
      color: #92400e;
      margin-bottom: 5px;
    }

    .footer-message strong {
      color: #78350f;
    }
    
    .thank-you {
      font-weight: 600;
      color: #374151;
      margin-top: 25px;
    }
    
    #email-footer {
      background: #f8fafc;
      padding: 25px 34px;
      border-top: 1px solid #e5e7eb;
    }
    
    #tagline-section {
      text-align: center;
      margin-bottom: 20px;
    }
    
    .small-tagline {
      font-size: 12px;
      color: #6b7280;
      margin-bottom: 8px;
    }
    
    .big-tagline {
      font-size: 14px;
      color: #374151;
      font-weight: 500;
    }
    
    .big-tagline a {
      color: #3b82f6;
      text-decoration: none;
    }
    
    .big-tagline a:hover {
      text-decoration: underline;
    }
    
    .company-details {
      text-align: center;
      padding-top: 15px;
      border-top: 1px solid #e5e7eb;
    }
    
    .footer-logo {
      height: 32px;
      width: auto;
     
      margin-bottom: 12px;
    }
    
    .company-title {
      font-size: 14px;
      font-weight: 600;
      color: #1f2937;
      margin-bottom: 8px;
    }
    
    .company-address-contact {
      font-size: 12px;
      color: #6b7280;
      line-height: 1.5;
    }
  </style>
</head>
<body>
  <div id="email-body">
    <div id="email-header">
      @if(!empty($logoPath) && file_exists(public_path($logoPath)))
        <img src="{{ url($logoPath) }}" alt="WMS Logo" />
      @else
        <h2>{{ $companyName }}</h2>
      @endif
    </div>

    <div id="email-content">
      <div class="greeting-section">
        @if($email_type == 'referral_signup_admin')
          Hello, <strong>Admin</strong>
        @else
          Hello, <strong>{{ $name ?? 'Valued Partner' }}</strong>
        @endif
      </div>

      <div class="notification-title">
        {{ $emailType['subject'] }}
      </div>

      <div class="alert-box">
        <p>{{ $emailType['message'] }}</p>
      </div>

      <div class="email-content-area">
        @if($email_type == 'referral_signup_user')
          <p>Thank you for your interest in becoming a referral partner with {{ $companyName }}! We're excited about the opportunity to work with you.</p>
          
          <p>Your application is currently under review by our team. We'll carefully evaluate your application and get back to you within 1-2 business days.</p>
          
          <div class="info-card">
            <h3>🔐 Application Details</h3>
            <p><strong>Name:</strong> {{ $name ?? 'N/A' }}</p>
            <p><strong>Email:</strong> {{ $email ?? 'N/A' }}</p>
            <p><strong>Mobile:</strong> {{ $mobile_number ?? 'N/A' }}</p>
            <p><strong>Status:</strong> <span class="status-badge">Pending Approval</span></p>
            <p><strong>Applied On:</strong> {{ $applied_at ? (\Carbon\Carbon::parse($applied_at)->format('M d, Y \a\t g:i A')) : now()->format('M d, Y \a\t g:i A') }}</p>
          </div>
          
          <p>Once approved, you'll receive your unique referral code and can start earning commissions by referring new customers to our platform.</p>
          
        @elseif($email_type == 'referral_signup_admin')
          <p>A new referral partner has submitted an application and is waiting for your review and approval.</p>
          
          <div class="info-card">
            <h3>📋 Partner Application Details</h3>
            <p><strong>Name:</strong> {{ $name ?? 'N/A' }}</p>
            <p><strong>Email:</strong> {{ $email ?? 'N/A' }}</p>
            <p><strong>Mobile:</strong> {{ $mobile_number ?? 'N/A' }}</p>
            <p><strong>Status:</strong> <span class="status-badge">Pending Review</span></p>
            <p><strong>Applied On:</strong> {{ $applied_at ? (\Carbon\Carbon::parse($applied_at)->format('M d, Y \a\t g:i A')) : now()->format('M d, Y \a\t g:i A') }}</p>
          </div>
          
          <p>Please review this application and take appropriate action (approve or reject) based on your referral partner criteria.</p>
          
          <a href="{{ env('FRONTEND_URL') }}/admin-login" class="action-button">Review Application</a>
          
        @elseif($email_type == 'referral_approved')
          <p>Congratulations! We're thrilled to welcome you as an official referral partner for {{ $companyName }}.</p>
          
          <div class="info-card">
            <h3>🔗 Your Referral Information</h3>
            <p><strong>Referral Code:</strong> {{ $referral_code ?? 'N/A' }}</p>
            <p><strong>Referral Link:</strong> {{ $referral_link ?? 'N/A' }}</p>
            <p><strong>Status:</strong> <span class="status-badge">Active</span></p>
            <p><strong>Approved On:</strong> {{ $approved_at ? (\Carbon\Carbon::parse($approved_at)->format('M d, Y \a\t g:i A')) : now()->format('M d, Y \a\t g:i A') }}</p>
          </div>
          
          <p>You can now start referring customers and earning commissions! Share your referral code or link with potential customers to start earning.</p>
          
          <a href="{{ env('FRONTEND_URL') }}/admin-login" class="login-button">Access Your Dashboard</a>
        @endif
      </div>

      @if($emailType['action_required'])
        <div class="footer-message">
          <p><strong>🔗 Quick Access:</strong> {{ $emailType['action_message'] }}</p>
        </div>
      @endif

      <div class="divider"></div>
      
      <div class="footer-message">
        <p><strong>💡 Support:</strong> If you have any questions about your referral partnership or need assistance, our support team is here to help.</p>
      </div>

      <div class="thank-you">
        Thank you,<br>
        <strong>{{ $companyName }} Team</strong>
      </div>
    </div>

    <div id="email-footer">
      <div id="tagline-section">
        <p class="small-tagline">This is an auto-generated email. Please do not reply.</p>
        <p class="big-tagline">For questions or support, contact 
          <a href="mailto:{{ $companyEmail }}">{{ $companyEmail }}</a>
        </p>
      </div>

      <div class="company-details">
        @if(!empty($logoPath) && file_exists(public_path($logoPath)))
          <img src="{{ url($logoPath) }}" class="footer-logo" alt="Logo">
        @endif
        <div class="company-title">{{ $companyName }}</div>
        <div class="company-address-contact">
          {{ $fullAddress }}<br />
        </div>
      </div>
    </div>
  </div>
</body>
</html>
