@php
    use App\Services\CompanyEmailDetails;

    // Get company details using global helper function
    $customer_id = $customer_id ?? null;
   $companyDetails = CompanyEmailDetails::getCompanyEmailDetails($customer_id);
    // Extract variables for easier use in template
    $logoPath = $companyDetails['logoPath'];
    $companyName = $companyDetails['companyName'];
    $companyAddress = $companyDetails['companyAddress'];
    $companyCity = $companyDetails['companyCity'];
    $companyState = $companyDetails['companyState'];
    $companyPostCode = $companyDetails['companyPostCode'];
    $companyCountry = $companyDetails['companyCountry'];
    $companyPhone = $companyDetails['companyPhone'];
    $companyEmail = $companyDetails['companyEmail'];
    $fullAddress = $companyDetails['companyAddressFull'];
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{{ $subject }}</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
  @php
    \Illuminate\Support\Facades\Log::info('OTP Email Template: Before including style partial', [
      'customer_id' => $customer_id ?? 'NULL',
      'email' => $email ?? 'NULL',
      'template_path' => 'Emails.roster_notification'
    ]);
    
    // Check if the partial file exists
    $stylePartialPath = resource_path('views/Emails/partial/style.blade.php');
    $stylePartialExists = file_exists($stylePartialPath);
    \Illuminate\Support\Facades\Log::info('OTP Email Template: Style partial file check', [
      'path' => $stylePartialPath,
      'exists' => $stylePartialExists,
      'readable' => $stylePartialExists ? is_readable($stylePartialPath) : false
    ]);
  @endphp
  @include('Emails.partial.style', ['customer_id' => $customer_id])
  @php
    \Illuminate\Support\Facades\Log::info('OTP Email Template: After including style partial');
  @endphp
</head>
<body>
  <div class="email-template">
    @include('Emails.partial.header', ['logoPath' => $logoPath])
    <div class="email-body">
      <div class="email-body-box-one">
          <div class="email-body-icon-one">
            <img src="{{ url('assets/img/Symbol-3.png') }}" >
          </div>
          <h2>Work Schedule Notification</h2>
          <p class="email-body-box-one-first-p">
              @if (isset($is_edit) && $is_edit)
                Your work schedule has been updated.
              @else
                A new work schedule has been assigned to you.
              @endif
          </p>
      </div>
      <div class="email-body-box-two">
        <div class="email-body-main-text">
          <p>
            Hi <span>{{ $name }}</span>,
            <br/><br/>
            @if (isset($is_edit) && $is_edit)
                <p>Your work schedule has been updated. Please review the changes below:</p>
            @else
                <p>This is to inform you about your work schedule assignment. Please review the details below:</p>
            @endif
          </p>
        </div>
        @if (isset($schedule_date) && !empty($schedule_date))
        <span class="email-body-button">
            {{ $schedule_date }}
            @if (isset($day_name) && !empty($day_name))
                ({{ $day_name }})
            @endif
        </span>
        @endif
        <div class="email-body-details-box">
          <h3>
            @if (isset($roster_template_name) && !empty($roster_template_name))
                {{ $roster_template_name }}
            @else
            Work Schedule Details
            @endif
          </h3>
          <table>
            <tr>
              <td>Time</td>
              <td style="text-align: end;">
                @if (isset($start_time) && !empty($start_time))
                    {{ $start_time }}
                @endif
                @if (isset($start_time) && !empty($start_time) && (isset($end_time) && !empty($end_time)))
                    -
                @endif
                @if (isset($end_time) && !empty($end_time))
                    {{ $end_time }}
                @endif
              </td>
            </tr>
            @if (isset($working_hours) && !empty($working_hours) && $working_hours > 0)
            <tr>
              <td>Working Hours</td>
              <td style="text-align: end;">
                {{ $working_hours }} hours
              </td>
            </tr>
             @endif
             @if (isset($break_minutes) && !empty($break_minutes) && $break_minutes > 0)
            <tr>
              <td>Break Time</td>
              <td style="text-align: end;">
                {{ $break_minutes }} minutes
              </td>
            </tr>
            @endif
            @if (isset($assigned_by) && !empty($assigned_by))
            <tr>
              <td style="border-bottom: none;padding-bottom:0px;">Assigned by</td>
              <td style="text-align: end;border-bottom: none;padding-bottom: 0px;">{{ $assigned_by }}</td>
            </tr>
            @endif
          </table>
           @if (isset($is_edit) && $is_edit && isset($changes) && !empty($changes))
          <h3 style="margin-top:20px;">
            Changes Made
          </h3>
          <table>
            @foreach ($changes as $field => $change)
              @php
                $fieldName = ucfirst(str_replace('_', ' ', $field));
                
                if ($field === 'start_time') {
                  $fieldName = 'Start Time';
                } elseif ($field === 'end_time') {
                  $fieldName = 'End Time';
                } elseif ($field === 'break_minutes') {
                  $fieldName = 'Break Time';
                } elseif ($field === 'color_code') {
                  $fieldName = 'Color Code';
                } elseif ($field === 'working_hours') {
                  $fieldName = 'Working Hours';
                }
              @endphp
              <tr>
                <td>{{ $fieldName }}</td>
                <td style="text-align: end;">
                  @if ($field === 'start_time' || $field === 'end_time')
                    {{ date('h:i A', strtotime($change['old'])) }} → {{ date('h:i A', strtotime($change['new'])) }}
                  @elseif($field === 'working_hours')
                    {{ round($change['old'] / 60, 2) }} hours → {{ round($change['new'] / 60, 2) }} hours
                  @else
                    {{ $change['old'] }} → {{ $change['new'] }}
                  @endif
                </td>
              </tr>
            @endforeach
          </table>
          @endif
        </div>
        @if (isset($shift_notes) && !empty($shift_notes))
        <div class="email-alert-box">
          <table>
            <tr>
              <td>
                <h3>Shift Notes:</h3>
                <p>{{ $shift_notes }}</p>
              </td>
            </tr>
          </table>
        </div>
        @endif
        <p class="email-body-thankyou-text">
            @if (isset($is_edit) && $is_edit)
                If you have any questions about the changes made to your schedule, please contact your
                supervisor or the HR department.
            @else
                If you have any questions or concerns about your schedule, please contact your supervisor or the
                HR department.
            @endif
          <br/><br/>
          Thank you,<br/>
          {{ $companyName }} Team
        </p>
      </div>
    </div>
   
   
    @include('Emails.partial.customer-footer', [
      'logoPath' => $logoPath,
      'fullAddress' => $fullAddress,
      'companyPhone' => $companyPhone,
      'companyEmail' => $companyEmail
    ])
  </div>
  @include('Emails.partial.admin-footer')
</body>
</html>
