@php
  use App\General\SettingsClass;
  use Illuminate\Support\Facades\DB;
  use Illuminate\Support\Facades\Route;
  use Illuminate\Support\Facades\Config;
  use App\Models\User;
  
  // Status configuration for subscription confirmation
  if (!isset($status_config)) {
    $status_config = [
      'subject' => $subject ?? 'Subscription Confirmation',
      'status_text' => 'Active',
      'color' => '#059669', // Green
      'background' => 'linear-gradient(135deg, #ECFDF5 0%, #D1FAE5 100%)',
      'icon' => '✨',
      'message' => 'Your subscription has been successfully activated!',
      'action_required' => false,
      'action_message' => ''
    ];
  }

  $logoPath = null;
  $companyName = env('APP_NAME', 'WMS');
  $companyAddress = '';
  $companyCity = '';
  $companyState = '';
  $companyPostCode = '';
  $companyCountry = '';
  $companyPhone = 'Contact Information';
  $companyEmail = env('EMAIL_ADDRESS', 'support@example.com');
  
  // Get admin settings data
    $admin = User::where('user_type', config('constants.user_types.admin'))->first();
    if ($admin) {
      $settings = DB::table('adminsettings')
          ->where('customer_id', $admin->id)
          ->get();
          
      // Transform into key-value pairs for easier access
      $settingsData = [];
      foreach ($settings as $setting) {
          $settingsData[$setting->key] = $setting->value;
      }
      
      // Get logo
      if (isset($settingsData['brand_logo_dark'])) {
          $logoPath = $settingsData['brand_logo_dark'];
      }
      
      // Get company information
      if (isset($settingsData['company_company_name'])) {
          $companyName = $settingsData['company_company_name'];
      }
      if (isset($settingsData['company_company_address'])) {
          $companyAddress = $settingsData['company_company_address'];
      }
      
      if (isset($settingsData['company_company_city'])) {
          $companyCity = $settingsData['company_company_city'];
      }
      
      if (isset($settingsData['company_company_state'])) {
          $companyState = $settingsData['company_company_state'];
      }
      
      if (isset($settingsData['company_company_post_code'])) {
          $companyPostCode = $settingsData['company_company_post_code'];
      }
      
      if (isset($settingsData['company_company_country'])) {
          $companyCountry = $settingsData['company_company_country'];
      }
      
      if (isset($settingsData['company_company_telephone'])) {
          $companyPhone = $settingsData['company_company_telephone'];
      }
      
      if (isset($settingsData['company_company_email'])) {
          $companyEmail = $settingsData['company_company_email'];
      }
    }
  
  
  // Format full address
  $fullAddress = $companyAddress;
  if (!empty($companyCity)) {
      $fullAddress .= ', ' . $companyCity;
  }
  if (!empty($companyState)) {
      $fullAddress .= ', ' . $companyState;
  }
  if (!empty($companyPostCode)) {
      $fullAddress .= ' ' . $companyPostCode;
  }
  if (!empty($companyCountry)) {
      $fullAddress .= ', ' . $companyCountry;
  }
  // Helper function to determine if a date is valid (not 1970-01-01)
  function isValidDate($date) {
    if (empty($date)) return false;
    if (strpos($date, '1970-01-01') !== false) return false;
    return true;
  }
  
  // Format the next billing date with a fallback
  $formattedNextBillingDate = isValidDate($next_billing_date) ? 
    $next_billing_date : 
    date('Y-m-d', strtotime('+' . $interval . ' months'));
    

@endphp
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{{ $subject }}</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">

  @include('Emails.partial.admin-style')
 
</head>
<body>
  <div class="email-template">
  @include('Emails.partial.header', ['logoPath' => $logoPath])
    <div class="email-body">
      <div class="email-body-box-one">
          <div class="email-body-icon-one">
            <img src="{{ url('assets/img/Symbol-4.png') }}" >
          </div>
          <h2>Subscription Confirmation</h2>
          <p class="email-body-box-one-first-p">Your subscription has been successfully activated!</p>
      </div>
      <div class="email-body-box-two">
        <div class="email-body-main-text">
          <p>
            Hi <span>{{$name}}</span>,
            <br/><br/>
            Welcome to our premium subscription service! We're excited to confirm that your subscription has been activated successfully. Below are the details of your subscription:
          </p>
        </div>
        <div class="email-body-details-box">
          <h3>
          Subscription Details
          </h3>
          <table>
            <tr>
              <td>Plan Name</td>
              <td style="text-align: end;">
              {{ $plan_name ?? 'N/A' }}
              </td>
            </tr>
            <tr>
              <td>Order ID</td>
              <td style="text-align: end;">
              {{ $order_id ?? 'N/A' }}
              </td>
            </tr>
            @if(isset($discount_amount) && $discount_amount > 0)
            <tr>
              <td>Original Price</td>
              <td style="text-align: end;">
              {{ number_format($original_price, 2) }} {{ $currency }}
              </td>
            </tr>
            <tr>
              <td>Discount ({{ $coupon_code }})</td>
              <td style="text-align: end;">
              {{ number_format($discount_amount, 2) }} {{ $currency }}
              </td>
            </tr>
            <tr>
              <td>Final Amount</td>
              <td style="text-align: end;">
              {{ number_format($price, 2) }} {{ $currency }}
              </td>
            </tr>
            @else
            <tr>
              <td>Amount</td>
              <td style="text-align: end;">
              {{ number_format($price, 2) }} {{ $currency }}
              </td>
            </tr>
            @endif
            <tr>
              <td >Subscription Period</td>
              <td style="text-align: end;">
              {{ $interval ?? 'N/A' }} Month(s)
              </td>
            </tr>
            <tr>
              <td style="border-bottom: none;padding-bottom:0px;">Next Billing Date</td>
              <td style="text-align: end;border-bottom: none;padding-bottom: 0px;">
              {{ $formattedNextBillingDate }}
              </td>
            </tr>
          </table>
        </div>
        <p class="email-body-thankyou-text">
        Your subscription is now active and you can start using all the premium features right away. We're committed to providing you with exceptional service throughout your subscription period.<br/>
        <a href="{{ env('FRONTEND_URL') }}" class="email-body-button">Login to Your Account</a>
        <br/><br/>
        If you have any questions about your subscription or need assistance with billing, please don't hesitate to contact our customer support team.
        <br/><br/>
        Thank you,<br/>
        {{ $companyName }} Team
        </p>
      </div>
    </div>
    @include('Emails.partial.admin-footer')
  </div>

</body>
</html>