@php
   use App\Services\CompanyEmailDetails;
 
   // Ensure customer_id is available
   $customer_id = $customer_id ?? null;
   $companyDetails = CompanyEmailDetails::getCompanyEmailDetails($customer_id);
   
    // Extract variables for easier use in template
    $logoPath = $companyDetails['logoPath'];
    $companyName = $companyDetails['companyName'];
    $companyAddress = $companyDetails['companyAddress'];
    $companyCity = $companyDetails['companyCity'];
    $companyState = $companyDetails['companyState'];
    $companyPostCode = $companyDetails['companyPostCode'];
    $companyCountry = $companyDetails['companyCountry'];
    $companyPhone = $companyDetails['companyPhone'];
    $companyEmail = $companyDetails['companyEmail'];
 
 
  // Format full address
  $fullAddress = $companyAddress;
  if (!empty($companyCity)) {
      $fullAddress .= ', ' . $companyCity;
  }
  if (!empty($companyState)) {
      $fullAddress .= ', ' . $companyState;
  }
  if (!empty($companyPostCode)) {
      $fullAddress .= ' ' . $companyPostCode;
  }
  if (!empty($companyCountry)) {
      $fullAddress .= ', ' . $companyCountry;
  }
@endphp
 
 
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{{ $subject }}</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
  @php
    \Illuminate\Support\Facades\Log::info('OTP Email Template: Before including style partial', [
      'customer_id' => $customer_id ?? 'NULL',
      'email' => $email ?? 'NULL',
      'template_path' => 'Emails.tender-invitation'
    ]);
    
    // Check if the partial file exists
    $stylePartialPath = resource_path('views/Emails/partial/style.blade.php');
    $stylePartialExists = file_exists($stylePartialPath);
    \Illuminate\Support\Facades\Log::info('OTP Email Template: Style partial file check', [
      'path' => $stylePartialPath,
      'exists' => $stylePartialExists,
      'readable' => $stylePartialExists ? is_readable($stylePartialPath) : false
    ]);
  @endphp
  @include('Emails.partial.style', ['customer_id' => $customer_id])
  @php
    \Illuminate\Support\Facades\Log::info('OTP Email Template: After including style partial');
  @endphp
</head>
<body>
  <div class="email-template">
    @include('Emails.partial.header', ['logoPath' => $logoPath])
    <div class="email-body">
      <div class="email-body-box-one">
          <div class="email-body-icon-one">
            <img src="{{ url('assets/img/Symbol.png') }}" >
          </div>
          <h2>Tender Invitation</h2>
          <p class="email-body-box-one-first-p">You have been invited to participate in a tender</p>
      </div>
      <div class="email-body-box-two">
        <div class="email-body-main-text">
          <p>
            Hi <span>{{ $subcontractor_name }}</span>,
            <br/><br/>
            You have been invited to participate in a tender. Please review the tender details below.
          </p>
        </div>
        <div class="email-body-details-box">
          <h3>
            Tender Details
          </h3>
          <table>
            <tr>
              <td>Title</td>
              <td style="text-align: end;">
                {{ $tender_title }}
              </td>
            </tr>
            <tr>
              <td>Reference</td>
              <td style="text-align: end;">
                {{ $tender_reference }}
              </td>
            </tr>
            <tr>
              <td>Project</td>
              <td style="text-align: end;">
                {{ $project_name }}
              </td>
            </tr>
            <tr>
              <td style="border-bottom: none;padding-bottom:0px;">Closing Date</td>
              <td style="text-align: end;border-bottom: none;padding-bottom: 0px;">{{ $closing_date }}</td>
            </tr>
          </table>
          </div>
        <div class="email-alert-box">
          <table>
            <tr>
              <td style="width: 50px;vertical-align: baseline;text-align: start;">
                <img src="{{ url('assets/img/alert-icon.png') }}" alt="">
              </td>
              <td>
                <h3>Important Notice</h3>
                <p>Please review the tender details and submit your bid before the closing date. If you have any questions, please contact us using the information provided below.</p>
              </td>
            </tr>
          </table>
        </div>
        <br/>
        <p class="email-body-thankyou-text">
        Thank you for your interest in our tender. We look forward to your participation.
        <br/><br/>
        Best regards,<br/>
        {{ $companyName }} Team
        </p>
        <br/>
        @if (env('APP_LINK_APPSTORE') || env('APP_LINK_APPSTORE_Apple'))
            <div class="app-download">
                <div style="display:flex;">
                    @if (env('APP_LINK_APPSTORE'))
                        <a class="store-card" href="{{ env('APP_LINK_APPSTORE') }}" target="_blank"
                            rel="noopener" style="margin-right: 10px; vertical-align: middle;">
                            <span class="store-badge">
                                <img src="https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png"
                                    alt="Get it on Google Play"
                                    style="width: 150px; border: 0; display: block;">
                            </span>
                        </a>
                    @endif
                    @if (env('APP_LINK_APPSTORE_Apple'))
                        <a class="store-card" href="{{ env('APP_LINK_APPSTORE_Apple') }}" target="_blank"
                        rel="noopener" style="margin-right: 10px;margin-top:8px; vertical-align: middle;">
                            <span class="store-badge">
                                <img src="{{ url('assets/img/apple-store.png') }}"
                                    alt="Apple"
                                    style="width: 125px; border: 0; display: block;">
                            </span>
                        </a>
                    @endif
                </div>
            </div>
        @endif
      </div>
    </div>
   
   
    @include('Emails.partial.customer-footer', [
      'logoPath' => $logoPath,
      'fullAddress' => $fullAddress,
      'companyPhone' => $companyPhone,
      'companyEmail' => $companyEmail
    ])
  </div>
  @include('Emails.partial.admin-footer')
</body>
</html>
 