@php
    use App\Services\CompanyEmailDetails;

    $companyDetails = CompanyEmailDetails::getCompanyEmailDetails($customer_id ?? null, $workspace_id ?? null);
    $logoPath = $companyDetails['logoPath'];
    $companyName = $companyDetails['companyName'];
    $companyAddress = $companyDetails['companyAddress'];
    $companyCity = $companyDetails['companyCity'];
    $companyState = $companyDetails['companyState'];
    $companyPostCode = $companyDetails['companyPostCode'];
    $companyCountry = $companyDetails['companyCountry'];
    $companyPhone = $companyDetails['companyPhone'];
    $companyEmail = $companyDetails['companyEmail'];
    $fullAddress =
        $companyDetails['companyAddressFull'] ??
        trim(
            ($companyAddress ?? '') .
                ', ' .
                ($companyCity ?? '') .
                ', ' .
                ($companyState ?? '') .
                ', ' .
                ($companyPostCode ?? '') .
                ', ' .
                ($companyCountry ?? ''),
        );
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Test Email</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
  @include('Emails.partial.style', ['customer_id' => $customer_id])
</head>
<body>
  <div class="email-template">
    @include('Emails.partial.header', ['logoPath' => $logoPath])
    <div class="email-body">
      <div class="email-body-box-one">
          <div class="email-body-icon-one" style="padding: 21px 0px 14px !important;">
            <img src="{{ url('assets/img/Symbol-4.png') }}" >
          </div>
          <h2>Test Email</h2>
          <p class="email-body-box-one-first-p">This is a test email to verify your email template design.</p>
      </div>
      <div class="email-body-box-two">
        <div class="email-body-main-text">
          <p>
            Hi there,
            <br/><br/>
            This is a test email to verify your email template configuration. If you can see this email correctly formatted 
            with your company's logo and color scheme, your email template is working properly.
          </p>
        </div>
        <div class="email-body-details-box">
          <h3>
            Template Information
          </h3>
          <table>
            <tr>
              <td>Email Type</td>
              <td style="text-align: end;">
                Test Email
              </td>
            </tr>
            <tr>
              <td>Status</td>
              <td style="text-align: end;">
                Template Verified
              </td>
            </tr>
            <tr>
              <td colspan="2" style="border-bottom: none;padding-bottom:0px;">Description</td>
            </tr>
            <tr>
              <td colspan="2" style="border-bottom: none;padding-bottom:0px;">
                This email template uses your company's branding including logo and color scheme. 
                All future emails sent from your account will use this same design template.
              </td>
            </tr>
          </table>
        </div>
        <br/>
        @if (env('APP_LINK_APPSTORE') || env('APP_LINK_APPSTORE_Apple'))
            <div class="app-download">
                <div style="display:flex;">
                    @if (env('APP_LINK_APPSTORE'))
                        <a class="store-card" href="{{ env('APP_LINK_APPSTORE') }}" target="_blank"
                            rel="noopener" style="margin-right: 10px; vertical-align: middle;">
                            <span class="store-badge">
                                <img src="https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png"
                                    alt="Get it on Google Play"
                                    style="width: 150px; border: 0; display: block;">
                            </span>
                        </a>
                    @endif
                    @if (env('APP_LINK_APPSTORE_Apple'))
                        <a class="store-card" href="{{ env('APP_LINK_APPSTORE_Apple') }}" target="_blank"
                        rel="noopener" style="margin-right: 10px;margin-top:8px; vertical-align: middle;">
                            <span class="store-badge">
                                <img src="{{ url('assets/img/apple-store.png') }}"
                                    alt="Apple"
                                    style="width: 125px; border: 0; display: block;">
                            </span>
                        </a>
                    @endif
                </div>
            </div>
        @endif
      </div>
    </div>
   
    @include('Emails.partial.customer-footer', [
      'logoPath' => $logoPath,
      'fullAddress' => $fullAddress,
      'companyPhone' => $companyPhone,
      'companyEmail' => $companyEmail
    ])
  </div>
  @include('Emails.partial.admin-footer')
</body>
</html>

