<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Meeting Details</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }

        .container {
            width: 100%;
            padding: 20px;
        }

        .btn {
            display: inline-block;
            padding: 10px 20px;
            font-size: 16px;
            color: #fff;
            background-color: #007bff;
            text-align: center;
            text-decoration: none;
            border-radius: 5px;
            margin-bottom: 20px;
        }

        .card {
            border: 1px solid #ddd;
            border-radius: 5px;
            margin-bottom: 20px;
        }

        .card-body {
            padding: 20px;
        }

        .call-detail {
            margin-bottom: 20px;
            border-bottom: 1px solid #ddd;
            padding-bottom: 10px;
        }

        .call-detail h4 {
            margin: 0;
        }

        .call-detail p {
            margin: 0;
            color: #555;
        }

        .row {
            display: flex;
            flex-wrap: wrap;
            margin: -10px;
            padding: 0px 30px;
        }

        .col-lg-6,
        .col-sm-12 {
            padding: 10px;
            box-sizing: border-box;
        }

        .col-lg-6 {
            width: 50%;
        }

        .d-flex {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 10px;
        }

        .badge {
            padding: 5px 10px;
            border-radius: 3px;
            color: #fff;
            background-color: #6c757d;
        }

        .border-start {
            border-left: 1px solid #ddd;
        }

        .text-center {
            text-align: center;
        }

        .text-danger {
            color: #dc3545;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        .table th,
        .table td {
            border: 1px solid #ddd;
            padding: 8px;
        }

        .table th {
            background-color: #007bff;
            color: #fff;
        }

        .table thead th {
            text-align: left;
        }

        .table img {
            max-width: 70px;
            max-height: 70px;
        }

        .table a {
            color: #007bff;
            text-decoration: none;
        }

        .table a:hover {
            text-decoration: underline;
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="card">
            <div class="card-body">
                <div class="call-detail">
                    <h4>{{ $meeting->agenda }}</h4>
                    <p>{{ $meeting->description }}</p>
                </div>
                <table style="width:100%;padding:0px 20px;">
                    <tr>
                        <td style="width:25%;">ORGANISER</td>
                        <td style="width:25%;text-align: end;padding:10px 0px;padding-right:20px;">
                            @foreach ($meeting->meeting_organisers as $organiser)
                                {{ $organiser->organiser->first_name }} {{ $organiser->organiser->middle_name }}
                                {{ $organiser->organiser->last_name }}
                            @endforeach
                        </td>
                        <td style="width:25%;padding-left:20px;border-left:1px solid black;">START DATE</td>
                        <td style="width:25%;text-align: end;">{{ formatDate($meeting->start_date) }}</td>
                    </tr>
                    <tr>
                        <td style="width:25%;padding:10px 0px;">MEETING OCCURANCE</td>
                        <td style="width:25%;text-align: end;padding:10px 0px;padding-right:20px;">
                            @if ($meeting->is_recurring == config('constants.meeting_recurring.one_time.key'))
                                <span class="badge">{{ config('constants.meeting_recurring.one_time.value') }}</span>
                            @else
                                <span class="badge">{{ config('constants.meeting_recurring.recurring.value') }}</span>
                            @endif
                        </td>
                        <td style="width:25%;padding:10px 0px;padding-left:20px;border-left:1px solid black;">END DATE</td>
                        <td style="width:25%;text-align: end;padding:10px 0px;">{{ formatDate($meeting->end_date) }}</td>
                    </tr>
                    <tr>
                        <td style="width:25%;">SITE</td>
                        <td style="width:25%;text-align: end;padding:10px 0px;padding-right:20px;">
                            {{ $meeting->meeting_site->title }}
                        </td>
                        <td style="width:25%;padding-left:20px;border-left:1px solid black;">TIMINGS</td>
                        <td style="width:25%;text-align: end;">
                            {{ formatTime($meeting->start_time) }} TO
                                {{ formatTime($meeting->end_time) }}
                        </td>
                    </tr>
                </table>
                {{-- <div class="row">
                    <div class="col-lg-6 col-sm-12">
                        <div class="d-flex">
                            <div class="p-2 me-auto">ORGANISER</div>
                            <div class="p-2">
                                @foreach ($meeting->meeting_organisers as $organiser)
                                    {{ $organiser->organiser->first_name }} {{ $organiser->organiser->middle_name }}
                                    {{ $organiser->organiser->last_name }}
                                @endforeach
                            </div>
                        </div>
                        <div class="d-flex">

                            <div class="p-2 me-auto">MEETING OCCURANCE</div>
                            <div class="p-2">
                                @if ($meeting->is_recurring == config('constants.meeting_recurring.one_time.key'))
                                    <span
                                        class="badge">{{ config('constants.meeting_recurring.one_time.value') }}</span>
                                @else
                                    <span
                                        class="badge">{{ config('constants.meeting_recurring.recurring.value') }}</span>
                                @endif
                            </div>
                        </div>
                        @if ($meeting->is_recurring == config('constants.meeting_recurring.recurring.key'))
                            @foreach (config('constants.meeting_frequency') as $frequency)
                                @if ($frequency['key'] == $meeting->frequency)
                                    <div class="d-flex">

                                        <div class="p-2 me-auto">MEETING FREQUENCY</div>
                                        <div class="p-2">
                                            <span class="badge">{{ $frequency['value'] }}</span>
                                        </div>
                                    </div>
                                @endif
                            @endforeach
                        @endif
                        <div class="d-flex">

                            <div class="p-2 me-auto">SITE</div>
                            <div class="p-2">{{ $meeting->meeting_site->title }}</div>
                        </div>
                    </div>
                    <div class="col-lg-6 col-sm-12 border-start">
                        <div class="d-flex">

                            <div class="p-2 me-auto">START DATE</div>
                            <div class="p-2">{{ formatDate($meeting->start_date) }}</div>
                        </div>
                        <div class="d-flex">

                            <div class="p-2 me-auto">END DATE</div>
                            <div class="p-2">{{ formatDate($meeting->end_date) }}</div>
                        </div>
                        <div class="d-flex">

                            <div class="p-2 me-auto">TIMINGS</div>
                            <div class="p-2">{{ formatTime($meeting->start_time) }} TO
                                {{ formatTime($meeting->end_time) }}</div>
                        </div>
                    </div>
                </div> --}}
                <div style="margin-top: 20px; text-align: center;">
                    <h4>Meeting Notes</h4>

                    {!! $meeting->notes??'' !!}
                  
                </div>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Employee</th>
                            <th>Date</th>
                            <th>Check-In/Check-Out</th>
                            <th>Document</th>
                        </tr>
                    </thead>
                    <tbody>
                    @if ($meeting_users->isNotEmpty())
                        @foreach ($meeting_users as $user)
                            <tr>
                                <td>{{ $user->first_name }} {{ $user->last_name }}</td>
                                <td>{{ formatDate($user->date) }}</td>
                                <td>{{ formatTime($user->check_in) }}/{{ formatTime($user->check_out) }}</td>
                                <td>
                                    @if ($user->documents->isNotEmpty())
                                        @foreach ($user->documents as $key => $doc)
                                            <div style="display: flex; justify-content: space-between; align-items: center; border-bottom: 1px solid #ddd; margin-bottom: 10px;">
                                                <div>
                                                    <p>{{ $key + 1 }} - {{ $doc->title }}</p>

                                                    @php
                                                        $imagePathSignature = $doc->document_path;
                                                    @endphp

                                                    @if (!empty($imagePathSignature))
                                                        <img src="{{ url($imagePathSignature) }}" style="width: 70px; height: 70px;">
                                                    @else
                                                        <p>No signature yet.</p>
                                                    @endif

                                                    <p>URL: {{ url($imagePathSignature) }}</p>
                                                </div>
                                            </div>
                                        @endforeach
                                    @else
                                        <p>No documents found for this user.</p>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td colspan="4" style="text-align: center">No Record Found!</td>
                        </tr>
                    @endif
                </tbody>


                <h3>Meeting Document Links:</h3>
                @foreach ($meeting->meeting_documents_only as $document)
                    <a target="_blank" href="{{url($document->document_path)}}">{{$document->title}}</a><br>
                @endforeach
            </div>
        </div>
    </div>
</body>

</html>
