<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Meeting Report</title>
    <style>
        /* Define page margins for printing/PDF */
        @page {
            margin: 20px 20px 0px 20px;
        }

        /* Fixed header styling */
        header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            height: 80px;
            padding: 10px 20px;
            background: transparent;
            z-index: 1000;
        }

        /* Fixed footer styling */
        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            height: 50px;
            padding: 5px 20px;
            border-top: 1px solid #cccccc;
            text-align: center;
            background: transparent;
            z-index: 1000;
        }

        /* Content area with padding to avoid overlap */
        .content {
            position: relative;
            top: 80px;
            padding-bottom: 150px;
        }
    </style>

</head>

<body style="margin: 0px;padding: 0px;font-family: 'Poppins', sans-serif;">
    @if($meeting_document_notes)
        <header style="padding: 10px 50px 0px 20px;">
            <table width="100%" style="border-collapse: collapse;">
                <tr>
                    <td>
                        <img src="{{'/assets/img/pdf_logo.png'}}" alt="" width="35%"> <!-- Reduced the image size -->
                    </td>
                    <td style="text-align: right; font-size: 18px; font-weight: 600; margin: 0px; color: #d2d2d2;">
                        Meeting Manager Report
                    </td>
                </tr>
            </table>
        </header>

        <div class="content">
            <div style="margin: 30px 0px;">
                <table width="100%" style="border-collapse: collapse;">
                    <tr>
                        <td style="border-bottom: 1px solid #1E1E1E;padding-left: 30px;padding-bottom: 15px;">
                            <p
                                style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                Project Name: <span style="font-weight: 400;color: #595959;">&nbsp;
                                    {{$meeting_project->project_title ?? ''}}</span>
                            </p>
                        </td>
                        <td style="border-bottom: 1px solid #1E1E1E;padding: 0px 30px 15px 30px;">
                            <p
                                style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                Project Number: <span style="font-weight: 400;color: #595959;">&nbsp;
                                    {{$meeting_document_notes->project_number ?? ''}}</span>
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                            <p
                                style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                Site Name: <span style="font-weight: 400;color: #595959;">&nbsp;
                                    {{$meeting_sites->site_title ?? ''}}</span>
                            </p>
                        </td>
                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px">
                            <p
                                style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                Prestart Faciliated by: <span style="font-weight: 400;color: #595959;">&nbsp;
                                    {{$faciliatedByfull_name}}</span>
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                            <p
                                style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                Start Date: <span style="font-weight: 400;color: #595959;">&nbsp;
                                    {{$meetings->start_date ?? ''}}</span>
                            </p>
                        </td>
                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px">
                            <p
                                style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                End Date: <span style="font-weight: 400;color: #595959;">&nbsp;
                                    {{$meetings->end_date ?? ''}}</span>
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <td style="border-bottom: 3px solid #1E1E1E;padding: 15px 0px 30px 30px;">
                            <p
                                style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                Timings: <span style="font-weight: 400;color: #595959;">&nbsp;
                                    {{ \Carbon\Carbon::parse($meetings->start_time)->format('H:i') ?? '' }} To
                                    {{ \Carbon\Carbon::parse($meetings->end_time)->format('H:i') ?? '' }}</span>
                            </p>
                        </td>
                        <td style="border-bottom: 3px solid #1E1E1E;padding: 15px 30px 30px;">
                            <p
                                style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                Comments on Weather: <span style="font-weight: 400;color: #595959;">&nbsp;
                                    {{$meeting_document_notes->comments_on_weather ?? ''}}</span>
                            </p>
                        </td>
                    </tr>

                </table>
            </div>
            <div style="position:fixed;bottom: 0; padding:5px 0px; width:100%;">
                <div style=" margin-left: 30px;margin-right: 30px;">
                    <table style="width:100%;">
                        <tr>
                            <td style="width: 55%; font-weight:600; text-align:left;font-size:14px;">Project Name:</td>
                            <td style="width: 55%; color:#7a7a7a; font-weight: 300; text-align:left;font-size:14px;">
                                {{ $meeting_project->project_title ?? 'N/A' }}</td>
                            <td style="width: 55%; font-weight:600; text-align:left;font-size:14px;">Project Number:</td>
                            <td style="width: 55%; color:#7a7a7a; font-weight: 300; text-align:left;font-size:14px;">
                                {{ $meeting_document_notes->project_number ?? 'N/A' }}</td>
                        </tr>
                    </table>
                </div>
            </div>
            <p class="page-break"></p>
            <div style="background-color: #059EF3; padding: 15px 30px; margin-top: 20px;">
                <h2 style="font-size: 18px; font-weight: 600; margin: 0px; color: #fff; text-transform: uppercase;">
                    This Document is read in conjunction with the High-Risk Construction Work Safe Work Method Statement –
                    Formwork.
                </h2>
            </div>
            @foreach($meeting_document_note_checkpoints as $checkpointTitle)
                <div style="padding: 15px 0px 15px 30px;border-bottom: 1px solid #1E1E1E;">

                    <div>
                        <p
                            style="font-family: 'Poppins', sans-serif; font-size: 14px; font-weight: 600; margin: 0px; color: #1E1E1E;">
                            {{ $checkpointTitle->meeting_document_settings_title }}
                        </p>
                    </div>
                    <div class="warphoja" style="font-size: 14px; font-weight: 600;text-wrap-mode:wrap;">
                        <p
                            style="font-family: 'Poppins', sans-serif; font-size: 14px; font-weight: 600; margin: 0px; color: #1E1E1E;">
                            {!! $checkpointTitle->meeting_document_settings_description ?? '' !!}
                        </p>
                    </div>

                </div>
            @endforeach
            @if ($type_of_setting == 'prestart')
                <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 30px;">
                    <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">
                        Prestart Meeting notes
                    </h2>
                </div>
                <table width="100%" style="border-collapse: collapse;">
                    <tr>
                        <td style="border-bottom: 1px solid #1E1E1E;padding: 30px 30px 30px 30px;" colspan="2">
                            <p
                                style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 400;margin: 0px;color: #1E1E1E;">
                                {!! $meeting_document_notes->prestart_meeting_notes ?? '' !!}
                            </p>
                        </td>
                    </tr>
                </table>
            @endif
            <div style="height:20px;"></div>
            @if ($type_of_setting == "toolbox")
                {{-- <div style="margin-left: 30px; margin-right: 30px;">
                    <table style="width: 100%; border-collapse: collapse;">
                        <tr>
                            <td style="width: 50%; font-weight: 600; text-align: left; font-size: 15px;">Safety Manager Reviewed:</td>
                            <td style="width: 50%; font-weight: 600; text-align: left; font-size: 15px;">Director Reviewed:</td>
                        </tr>
                        <tr>
                            <td style="width: 50%; color: #7a7a7a; font-weight: 300; text-align: left; font-size: 14px;">
                                <strong>Name:</strong> {{ $toolboxData[0]->safety_manager_name ?? 'N/A' }}<br>
                                <strong>Date:</strong> {{ $toolboxData[0]->safety_manager_date ?? 'N/A' }}
                            </td>
                            <td style="width: 50%; color: #7a7a7a; font-weight: 300; text-align: left; font-size: 14px;">
                                <strong>Name:</strong> {{ $toolboxData[0]->director_name ?? 'N/A' }}<br>
                                <strong>Date:</strong> {{ $toolboxData[0]->director_date ?? 'N/A' }}
                            </td>
                        </tr>
                    </table>
                </div> --}}
            
            <div style="background-color: #059EF3; padding: 15px 30px; margin-top: 30px;">
                <h2 style="font-size: 18px; font-weight: 600; margin: 0px; color: #fff; text-transform: uppercase;">Points Raised & Corrective Action</h2>
            </div>
            <table width="100%" style="border-collapse: collapse;">
                <thead>
                    <tr>
                        <th style="font-size: 16px; font-weight: 600; color: #1E1E1E; background-color: #F1F1F1; padding: 10px 0px; text-align: center; border-right: 1px solid #898989;">
                            Points Raised and Corrective Action Required<br>
                            (Please add additional pages if more required)
                        </th>                        
                        <th style="font-size: 16px; font-weight: 600; color: #1E1E1E; background-color: #F1F1F1; padding: 10px 0px; text-align: center; border-right: 1px solid #898989;">
                            Action By
                        </th>
                        <th style="font-size: 16px; font-weight: 600; color: #1E1E1E; background-color: #F1F1F1; padding: 10px 0px; text-align: center; border-right: 1px solid #898989;">
                            Date Actioned
                        </th>
                    </tr>
                </thead>
                <tbody>
                    {{-- @if($toolboxData[1]->isNotEmpty()) <!-- This accesses the ToolboxAction collection -->
                        @foreach($toolboxData[1] as $toolboxAction) <!-- Loop through ToolboxAction items -->
                            <tr>
                                <td style="text-align: center; padding: 20px 0px; border-bottom: 1px solid #1E1E1E;">
                                    {{ $toolboxAction->action_required ?? '' }}
                                </td>
                                <td style="text-align: center; padding: 20px 0px; border-bottom: 1px solid #1E1E1E;">
                                    {{ $toolboxAction->action_by ?? '' }}
                                </td>
                                <td style="text-align: center; padding: 20px 0px; border-bottom: 1px solid #1E1E1E;">
                                    {{ $toolboxAction->date_actioned }}
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <p>No record found.</p>
                    @endif --}}
                </tbody>
            </table>
        @endif
        
        @if ($type_of_setting == "prestart")
    
            <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 30px;">
                <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">Erecting
                    Framework</h2>
            </div>
            <table width="100%" style="border-collapse: collapse;">
                <thead>
                    <tr>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            #</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Building</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Levels</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Area</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Workforce Allocation</th>
                    </tr>
                </thead>
                <tbody>
                    @if($erecting_framework->isNotEmpty())

                        @foreach($erecting_framework as $index => $erecting_framework_data)
                            <tr>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">{{ $index + 1 }}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{$erecting_framework_data->building ?? ''}}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $erecting_framework_data->level }}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $erecting_framework_data->area }}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $erecting_framework_data->workfore_allocation}}
                                </td>
                        @endforeach
                    @else
                        <p>No record found.</p>
                    @endif
                    </tr>
                </tbody>
            </table>
            <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 30px;">
                <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">Stripping
                    Formwork</h2>
            </div>
            <table width="100%" style="border-collapse: collapse;">
                <thead>
                    <tr>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            #</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Building</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Levels</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Area</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Workforce Allocation</th>
                    </tr>
                </thead>
                <tbody>
                    @if($stripping_framework->isNotEmpty())

                        @foreach($stripping_framework as $index => $stripping_framework_data)
                            <tr>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">{{ $index + 1 }}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{$stripping_framework_data->building ?? ''}}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $stripping_framework_data->level }}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $stripping_framework_data->area }}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $stripping_framework_data->workfore_allocation}}
                                </td>
                        @endforeach
                    @else
                        <p>No record found.</p>
                    @endif
                    </tr>
                </tbody>
            </table>
            <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 30px;">
                <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">Jumpform
                    Jumping</h2>
            </div>
            <table width="100%" style="border-collapse: collapse;">
                <thead>
                    <tr>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            #</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Building</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Levels</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Area</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Workforce Allocation</th>
                    </tr>
                </thead>
                <tbody>
                    @if($jumping_framework->isNotEmpty())

                        @foreach($jumping_framework as $index => $jumping_framework_data)
                            <tr>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">{{ $index + 1 }}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{$jumping_framework_data->building ?? ''}}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $jumping_framework_data->level }}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $jumping_framework_data->area }}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $jumping_framework_data->workfore_allocation}}
                                </td>
                        @endforeach
                    @else
                        <p>No record found.</p>
                    @endif
                    </tr>
                </tbody>
            </table>
            <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 30px;">
                <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">Installing
                </h2>
            </div>
            <table width="100%" style="border-collapse: collapse;">
                <thead>
                    <tr>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            #</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Building</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Levels</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Area</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Workforce Allocation</th>
                    </tr>
                </thead>
                <tbody>
                    @if($installing_framework->isNotEmpty())

                        @foreach($installing_framework as $index => $installing_framework_data)
                            <tr>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">{{ $index + 1 }}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{$installing_framework_data->building ?? ''}}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $installing_framework_data->level }}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $installing_framework_data->area }}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $installing_framework_data->workfore_allocation}}
                                </td>
                        @endforeach
                    @else
                        <p>No record found.</p>
                    @endif
                    </tr>
                </tbody>
            </table>
            <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 30px;">
                <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">Dismantling
                </h2>
            </div>
            <table width="100%" style="border-collapse: collapse;">
                <thead>
                    <tr>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            #</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Building</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Levels</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Area</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Workforce Allocation</th>
                    </tr>
                </thead>
                <tbody>
                    @if($dismantling_framework->isNotEmpty())

                        @foreach($dismantling_framework as $index => $dismantling_framework_data)
                            <tr>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">{{ $index + 1 }}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{$dismantling_framework_data->building ?? ''}}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $dismantling_framework_data->level }}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $dismantling_framework_data->area }}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $dismantling_framework_data->workfore_allocation}}
                                </td>
                        @endforeach
                    @else
                        <p>No record found.</p>
                    @endif
                    </tr>
                </tbody>
            </table>
            <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 30px;">
                <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">Stripping
                </h2>
            </div>
            <table width="100%" style="border-collapse: collapse;">
                <thead>
                    <tr>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            #</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Building</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Levels</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Area</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Workforce Allocation</th>
                    </tr>
                </thead>
                <tbody>
                    @if($stripping_no_framework->isNotEmpty())

                        @foreach($stripping_no_framework as $index => $stripping_no_framework_data)
                            <tr>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">{{ $index + 1 }}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{$stripping_no_framework_data->building ?? ''}}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $stripping_no_framework_data->level }}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $stripping_no_framework_data->area }}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $stripping_no_framework_data->workfore_allocation}}
                                </td>
                        @endforeach
                    @else
                        <p>No record found.</p>
                    @endif
                    </tr>
                </tbody>
            </table>
            <div style="height:50px;"></div>
            <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 30px;">
                <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">Preparing
                    Wall</h2>
            </div>
            <table width="100%" style="border-collapse: collapse;">
                <thead>
                    <tr>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            #</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Building</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Levels</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Area</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Workforce Allocation</th>
                    </tr>
                </thead>
                <tbody>
                    @if($preparing_walls->isNotEmpty())

                        @foreach($preparing_walls as $index => $preparing_walls_data)
                            <tr>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">{{ $index + 1 }}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $preparing_walls_data->building ?? ''}}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $preparing_walls_data->level }}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $preparing_walls_data->area }}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $preparing_walls_data->workfore_allocation}}
                                </td>
                        @endforeach
                    @else
                        <p>No record found.</p>
                    @endif
                    </tr>
                </tbody>
            </table>
            <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 30px;">
                <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">Bondek</h2>
            </div>
            <table width="100%" style="border-collapse: collapse;">
                <thead>
                    <tr>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            #</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Building</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Levels</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Area</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Workforce Allocation</th>
                    </tr>
                </thead>
                <tbody>
                    @if($bondek->isNotEmpty())

                        @foreach($bondek as $index => $bondek_data)
                            <tr>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">{{ $index + 1 }}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $bondek_data->building ?? ''}}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $bondek_data->level }}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $bondek_data->area }}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $bondek_data->workfore_allocation}}
                                </td>
                        @endforeach
                    @else
                        <p>No record found.</p>
                    @endif
                    </tr>
                </tbody>
            </table>
            <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 30px;">
                <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">Other</h2>
            </div>
            <table width="100%" style="border-collapse: collapse;">
                <thead>
                    <tr>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            #</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Building</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Levels</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Area</th>
                        <th
                            style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                            Workforce Allocation</th>
                    </tr>
                </thead>
                <tbody>
                    @if($other->isNotEmpty())

                        @foreach($other as $index => $other_data)
                            <tr>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">{{ $index + 1 }}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $other_data->building ?? ''}}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $other_data->level }}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $other_data->area }}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $other_data->workfore_allocation}}
                                </td>
                        @endforeach
                    @else
                        <p>No record found.</p>
                    @endif
                    </tr>
                </tbody>
            </table>
        @endif
        <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 30px;">
            <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">Worker Details</h2>
        </div>

        <table width="100%" style="border-collapse: collapse;">
            <thead>
                <tr>
                    <th
                        style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                        #
                    </th>
                    <th
                        style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                        Name of Worker(s)
                    </th>
                    <th
                        style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                        Worker signature(s)
                    </th>
                    <th
                        style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;border-right: 1px solid #898989;">
                        Company
                    </th>
                </tr>
            </thead>
            <tbody>
                @if (!empty($formatted_signatures) && count($formatted_signatures))
                    @foreach ($formatted_signatures as $index => $signature)
                        @if (!empty($signature['employee_name']) && !empty($signature['signature_data']))
                            <tr>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $index + 1 }}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    {{ $signature['employee_name'] ?? '' }}
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    <img src="{{ get_signed_document_url($signature['signature_data']) }}"
                                        alt="Signature" width="70" height="70">
                                </td>
                                <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                    Fastform Group Australia Pty Ltd
                                </td>
                            </tr>
                        @endif
                    @endforeach
                @else
                    <p>No record found.</p>
                @endif
            </tbody>
        </table>
    @else
        <p>No Note Record found</p>
    @endif
    </div>
    <div class="footer">
        <div style="margin-left: 30px;margin-right: 30px;">
            <table style="width:100%;">
                <tr>
                    <td style="width: 45%; font-weight:600; text-align:left;font-size:14px;">Project Name:</td>
                    <td style="width: 55%; color:#7a7a7a; font-weight: 300; text-align:left;font-size:14px;">
                        {{ $meeting_project->project_title ?? 'N/A' }}</td>
                    <td style="width: 45%; font-weight:600; text-align:left;font-size:14px;">Project Number:</td>
                    <td style="width: 55%; color:#7a7a7a; font-weight: 300; text-align:left;font-size:14px;">
                        {{ $meeting_document_notes->project_number ?? 'N/A' }}</td>
                </tr>
            </table>
        </div>
    </div>
</body>

</html>