<?php

namespace App\Http\Controllers;

use DB;
use App\Models\User;
use App\Models\EmpPermit;
use Illuminate\Http\Request;
use App\Models\EmpPersonalDetails;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class EmpPermitController extends Controller
{
    public function index()
    {
        $userTable = $this->getUserTable();
        $query = EmpPermit::query();
        if ($userTable === "customer") {
            $query->where('del', '0')->where('customer_id', auth()->id())
                ->where('workspace_id', auth()->user()->current_workspace_id);
        }
        if ($userTable === "emp") {
          
            $query->where('del', '0')->where('customer_id', auth()->user()->customer_id) // Assuming customer_id links employee to projects
                ->where('workspace_id', auth()->user()->workspace_id);
        }

        $emp_permits =  $query->get();
        
        return $this->success($emp_permits, 'Work Permits Type Get Successfully');
    }

    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
        ]);
        
        if ($validator->fails()) {

            $errors = $validator->errors();

            return $this->error($errors,422);



        } else {
            $user = auth()->user();

           $validatedData =  $validator->validated();
           $userTable = $this->getUserTable();
           $auth_id =0;
           $workspace_id = 0;
           if ($userTable === "customer") {
               $auth_id = Auth::user()->id;
               $workspace_id = Auth::user()->current_workspace_id;  
               $authPersonalDetails = User::where('id', Auth::user()->id)->first();
               
               
           }
           if ($userTable === "emp") {
               $auth_id = auth()->user()->customer_id;
               $workspace_id = auth()->user()->workspace_id;
               $authPersonalDetails = EmpPersonalDetails::where('emp_id', Auth::user()->id)->first();  
           }
           $validatedData['customer_id'] = $auth_id;
           $validatedData['workspace_id'] = $workspace_id;
           $validatedData['created_by'] = Auth::user()->id;
           
           EmpPermit::insert($validatedData);

           $emp_permits =  EmpPermit::where('customer_id',$auth_id)
                            ->where('workspace_id',  $workspace_id)
                            ->where('del', '0') 
                            ->get();

           $data['emp_permits'] = $emp_permits;
           
           return $this->success($data, 'Work Permits Type Saved Successfully');           
        }        
    }

    public function show($id)
    {
        //
    }

    public function permit_edit(Request $request)
    {
      $id=$request->id;
        $userTable = $this->getUserTable();
        $EmpPermit = EmpPermit::find($id);
        if (
            $userTable == "customer" && ($EmpPermit->workspace_id != auth()->user()->current_workspace_id || $EmpPermit->customer_id != auth()->user()->id)
        ) {
            return $this->message('You do not have access to this Employee Permit', 403);
        }

        if ($userTable == "emp" && ($EmpPermit->customer_id != auth()->user()->customer_id || $EmpPermit->workspace_id != auth()->user()->workspace_id)) {
            return $this->message('You do not have access to this Employee Permit', 403);
        }
        return $this->success($EmpPermit, 'Get Employee Permit Details Successfully');
    }

    public function permit_update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required',
            'title' => 'required'
        ]);
        
        if ($validator->fails()) {

            $errors = $validator->errors();

            return $this->error($errors,422);

        } else {
            $id=$request->id;
            $user = auth()->user();
            $validatedData =  $validator->validated();
            
            $emp_permits = EmpPermit::where('id', $id)->first();
            $userTable = $this->getUserTable();
        
            if ($userTable == "customer" && ($emp_permits->workspace_id != auth()->user()->current_workspace_id || $emp_permits->customer_id != auth()->user()->id)
            ) {
                return $this->message('You do not have access to this emp_permits', 403);
            }

            if ($userTable == "emp" && ($emp_permits->customer_id != auth()->user()->customer_id || $emp_permits->workspace_id != auth()->user()->workspace_id)) {
                return $this->message('You do not have access to this emp_permits', 403);
            }
            if (!$emp_permits) {
                return $this->notFound('emp_permits Not Found', 404);
            }
            $emp_permits->update($validatedData);

            if($userTable == "customer"){
                $data['emp_permits'] = EmpPermit::where('customer_id', $user->id)
                ->where('workspace_id', $user->current_workspace_id)
                ->where('del', '0')
                ->get();
            }
            elseif($userTable == "emp"){
                $data['emp_permits'] = EmpPermit::where('customer_id',auth()->user()->customer_id)
                ->where('workspace_id', auth()->user()->workspace_id)
                ->where('del', '0')
                ->get();
            }

            return $this->success($data, 'Work Permits Updated Successfully');
    
            }        

    }
        public function permit_delete(Request $request)
        {

            $id=$request->id;
            $userTable = $this->getUserTable();
         
            $EmpPermit = EmpPermit::find($id);
        
            if ($userTable == "customer" && ($EmpPermit->workspace_id != auth()->user()->current_workspace_id || $EmpPermit->customer_id != auth()->user()->id)) {
                return $this->message('You do not have access to this Employee Permit', 403);
            }

            if ($userTable == "emp" && ($EmpPermit->customer_id != auth()->user()->customer_id || $EmpPermit->workspace_id != auth()->user()->workspace_id)) {
                return $this->message('You do not have access to this Employee Permit', 403);
            }
            $EmpPermit->del='1';
            $EmpPermit->save();

            $user = auth()->user();
            if($userTable == "customer"){
                    $data['emp_permits'] = EmpPermit::where('customer_id', $user->id)
                    ->where('workspace_id', $user->current_workspace_id)
                    ->where('del', '0')
                    ->get();
                }
                elseif($userTable == "emp"){
                    $data['emp_permits'] = EmpPermit::where('customer_id',auth()->user()->customer_id)
                    ->where('workspace_id', auth()->user()->workspace_id)
                    ->where('del', '0')
                    ->get();
                }
    
            return $this->success($data, 'Work Permits Deleted Successfully');
        }
}
