<?php

namespace App\Http\Controllers;

use DB;
use App\Models\User;
use Illuminate\Http\Request;
use App\Models\EmpWorkExperience;
use App\Models\EmpPersonalDetails;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class EmpWorkExperienceController extends Controller
{
    public function index()
    {
        $userTable = $this->getUserTable();
        $query = EmpWorkExperience::query();
        if ($userTable === "customer") {
            $query->where('del', '0')->where('customer_id', auth()->id())
                ->where('workspace_id', auth()->user()->current_workspace_id);
        }
        if ($userTable === "emp") {
            $query->where('del', '0')->where('customer_id', auth()->user()->customer_id) // Assuming customer_id links employee to projects
                ->where('workspace_id', auth()->user()->workspace_id);
        }
        
        $emp_work_experiences =  $query->get();

 
        return $this->success($emp_work_experiences,'Worker Experience Get Successfully');
    }

    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        $user = auth()->user();
        $validator = Validator::make($request->all(), [
            'title' => 'required',
        ]);
        
        if ($validator->fails()) {

            $errors = $validator->errors();
            return $this->error($errors,422);

        } else {
          
           $validatedData =  $validator->validated();
           
           $userTable = $this->getUserTable();
           $auth_id =0;
           $workspace_id = 0;
           if ($userTable === "customer") {
               $auth_id = Auth::user()->id;
               $workspace_id = Auth::user()->current_workspace_id;  
               $authPersonalDetails = User::where('id', Auth::user()->id)->first();
               
               
           }

           if ($userTable === "emp") {
               $auth_id = auth()->user()->customer_id;
               $workspace_id = auth()->user()->workspace_id;
               $authPersonalDetails = EmpPersonalDetails::where('emp_id', Auth::user()->id)->first();  
           }

           $validatedData['customer_id'] = $auth_id;
           $validatedData['workspace_id'] = $workspace_id;
           $validatedData['created_by'] = Auth::user()->id;
           EmpWorkExperience::insert($validatedData);

           $emp_work_experiences =  EmpWorkExperience::where('customer_id', $auth_id)
                                                    ->where('workspace_id', $workspace_id)
                                                    ->where('del', '0') 
                                                    ->get();

           $data['emp_work_experiences'] = $emp_work_experiences;
    
           return $this->success($data,'Worker Experience Saved Successfully');
           
        }        

    }

    public function show($id)
    {
        //
    }

    public function work_experience_edit(Request $request)
    {
        $id=$request->id;
        $userTable = $this->getUserTable();
        $emp_work_experiences = EmpWorkExperience::find($id);
        if (
            $userTable == "customer" && ($emp_work_experiences->workspace_id != auth()->user()->current_workspace_id || $emp_work_experiences->customer_id != auth()->user()->id)
        ) {
            return $this->message('You do not have access to this Employee worker experience', 403);
        }
        if ($userTable == "emp" && ($emp_work_experiences->customer_id != auth()->user()->customer_id || $emp_work_experiences->workspace_id != auth()->user()->workspace_id)) {
            
            return $this->message('You do not have access to this Employee worker experience', 403);
        }
        $data['emp_work_experiencess'] = $emp_work_experiences;
 
        return $this->success($data, 'Worker experience  Get Successfully');
    }

    public function work_experience_update(Request $request)
    {
        
        $user = auth()->user();
        $validator = Validator::make($request->all(), [
            'id' => 'required',
            'title' => 'required'
        ]);
        
        if ($validator->fails()) {

            $errors = $validator->errors();
            return $this->error($errors,422);

        } else {
            $id=$request->id;
            $validatedData =  $validator->validated();
            $emp_work_experiences = EmpWorkExperience::where('id', $id)->first();
            $userTable = $this->getUserTable();
        
            if ($userTable == "customer" && ($emp_work_experiences->workspace_id != auth()->user()->current_workspace_id || $emp_work_experiences->customer_id != auth()->user()->id)
            ) {
                return $this->message('You do not have access to this Employee worker Types', 403);
            }

            if ($userTable == "emp" && ($emp_work_experiences->customer_id != auth()->user()->customer_id || $emp_work_experiences->workspace_id != auth()->user()->workspace_id)) {
                return $this->message('You do not have access to this Employee worker Types', 403);
            }
            if (!$emp_work_experiences) {
                return $this->notFound('Employee worker Types Not Found', 404);
            }
            $emp_work_experiences->update($validatedData);

            if($userTable == "customer"){
                $data['emp_work_experiences'] = EmpWorkExperience::where('customer_id', $user->id)
                ->where('workspace_id', $user->current_workspace_id)
                ->where('del', '0')
                ->get();
            }

            elseif($userTable == "emp"){
                $data['emp_work_experiences'] = EmpWorkExperience::where('customer_id',auth()->user()->customer_id)
                ->where('workspace_id', auth()->user()->workspace_id)
                ->where('del', '0')
                ->get();
            }
            return $this->success($data, 'Worker Experience Updated Successfully');
        }        
    }

    public function work_experience_delete(Request $request)
    {
        $id=$request->id;
        $userTable = $this->getUserTable();
        $EmpWorkExperience = EmpWorkExperience::find($id);
        if ($userTable == "customer" && ($EmpWorkExperience->workspace_id != auth()->user()->current_workspace_id || $EmpWorkExperience->customer_id != auth()->user()->id)) {
            return $this->message('You do not have access to this Employee experience', 403);
        }
        if ($userTable == "emp" && ($EmpWorkExperience->customer_id != auth()->user()->customer_id || $EmpWorkExperience->workspace_id != auth()->user()->workspace_id)) {
            return $this->message('You do not have access to this Employee experience', 403);
        }
        $EmpWorkExperience->del='1';
        $EmpWorkExperience->save();
        $user = auth()->user();
        if($userTable == "customer"){
                $data['emp_work_experiences'] = EmpWorkExperience::where('customer_id', $user->id)
                ->where('workspace_id', $user->current_workspace_id)
                ->where('del', '0')
                ->get();
            }
            elseif($userTable == "emp"){
                $data['emp_work_experiences'] = EmpWorkExperience::where('customer_id',auth()->user()->customer_id)
                ->where('workspace_id', auth()->user()->workspace_id)
                ->where('del', '0')
                ->get();
            }

        return $this->success($data, 'Worker Experience Deleted Successfully');
    }
}
