<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Traits\ProjectTaskManagementTrait;

class ProjectTaskManagementController extends Controller
{
    use ProjectTaskManagementTrait;

    /**
     * Display a listing of project management tasks
     */
    public function index(Request $request)
    {
        return $this->getProjectManagementTasks($request);
    }

    /**
     * Store a newly created project management task
     */
    public function store(Request $request)
    {
        return $this->createProjectManagementTask($request);
    }

    /**
     * Display the specified project management task
     */
    public function show(Request $request, $id)
    {
        $ids = $this->getCustomerAndWorkspaceIds();
        return $this->getProjectManagementTaskById($request, $id, $ids);
    }

    /**
     * Update the specified project management task (general update)
     */
    public function update(Request $request)
    {
        return $this->updateProjectManagementTask($request);
    }

    /**
     * Update the specified project management task status
     */
    public function updateStatus(Request $request)
    {
        return $this->updateProjectManagementTaskStatus($request);
    }

    /**
     * Update the specified project management task documents
     */
    public function uploadDocuments(Request $request)
    {
        return $this->uploadProjectManagementDocuments($request);
    }

    /**
     * Update a project management document (comment or document or both)
     */
    public function updateDocument(Request $request)
    {
        return $this->updateProjectManagementDocument($request);
    }

    /**
     * Delete a project management document
     */
    public function deleteDocument($id)
    {
        return $this->deleteProjectManagementDocument($id);
    }

    /**
     * Get all project management tasks by site_id
     */
    public function getTasksBySiteId(Request $request)
    {
        return $this->getProjectManagementTasksBySiteId($request);
    }

    /**
     * Delete the specified project management task
     */
    public function destroy($id)
    {
        return $this->deleteProjectManagementTask($id);
    }
}
