<?php

namespace App\Http\Controllers;

use App\Models\WHSQEReportLog;
use App\Models\WhsqReport;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class WHSQEReportLogController extends Controller
{
    
    // public function index(Request $request)
    // {
    //     $ids = $this->getCustomerAndWorkspaceIds();
    //     $selectedReportId = $request->report_id;
    //     $logs = WHSQEReportLog::with(['employee'])
    //         ->where('customer_id', $ids['customer_id'])
    //         ->where('workspace_id', $ids['workspace_id'])
    //         ->when($selectedReportId, function ($query) use ($selectedReportId) {
    //             return $query->where('report_id', $selectedReportId);
    //         })
    //         ->orderBy('created_at', 'desc')
    //         ->get();
    //     return $this->success($logs);
    // }

    public function getReportLogs(Request $request, $reportId)
    {
        $ids = $this->getCustomerAndWorkspaceIds();
        
        $query = WHSQEReportLog::where('customer_id', $ids['customer_id'])
            ->where('workspace_id', $ids['workspace_id']);
            
        if($reportId != 0){
            $query->where('report_id', $reportId);
        }

        // Apply search filter across multiple columns
        if ($request->filled('search')) {
            $searchTerm = $request->search;
            $query->where(function ($q) use ($searchTerm) {
                // Search in action_type
                $q->where('action_type', 'like', '%' . $searchTerm . '%')
                    // Search in step_number
                    ->orWhere('step_number', 'like', '%' . $searchTerm . '%')
                    // Search in message
                    ->orWhere('message', 'like', '%' . $searchTerm . '%')
                    // Search in employee name (first_name, middle_name, last_name)
                    ->orWhereHas('employee', function ($subquery) use ($searchTerm) {
                        $subquery->where('first_name', 'like', '%' . $searchTerm . '%')
                            ->orWhere('middle_name', 'like', '%' . $searchTerm . '%')
                            ->orWhere('last_name', 'like', '%' . $searchTerm . '%');
                    })
                    // Search in customer name
                    ->orWhereHas('customer', function ($subquery) use ($searchTerm) {
                        $subquery->where('name', 'like', '%' . $searchTerm . '%')
                            ->orWhere('email', 'like', '%' . $searchTerm . '%');
                    })
                    // Search in report (document_title, document_number)
                    ->orWhereHas('report', function ($subquery) use ($searchTerm) {
                        $subquery->where('document_title', 'like', '%' . $searchTerm . '%')
                            ->orWhere('document_number', 'like', '%' . $searchTerm . '%')
                            ->orWhere('revision_number', 'like', '%' . $searchTerm . '%');
                    });
            });
        }
        
        if($request->filled('pagination') || !empty($request->filters)){
            $result = $this->searchFilterRecord($query, $request);
            
            if (method_exists($result, 'getCollection')) {
                // It's a paginated result
                $result->getCollection()->transform(function ($log) {
                    if ($log->employee_id == 0) {
                        $log->load('customer');
                    } else {
                        $log->load('employee');
                    }
                    return $log;
                });
                
                // Transform the paginated result
                $result->getCollection()->transform(function ($log) {
                    return $this->transformLogData($log);
                });
                
                return $this->success($result);
            } else {
                // It's not paginated
                $logs = $result->map(function ($log) {
                    if ($log->employee_id == 0) {
                        $log->load('customer');
                    } else {
                        $log->load('employee');
                    }
                    return $log;
                });
                
                // Transform the logs
                $logs = $logs->map(function ($log) {
                    return $this->transformLogData($log);
                });
                
                return $this->success($logs);
            }
        } else {
            // No pagination/filters
            $logs = $query->orderBy('created_at', 'desc')->get();
            
            $logs = $logs->map(function ($log) {
                if ($log->employee_id == 0) {
                    $log->load('customer');
                } else {
                    $log->load('employee');
                }
                return $log;
            });

            // Transform the logs
            $logs = $logs->map(function ($log) {
                return $this->transformLogData($log);
            });

            return $this->success($logs);
        }
    }
    private function transformLogData($log)
    {
        // Remove the nested customer/employee objects
        unset($log->customer, $log->employee);
        
        // Add action_person field
        if ($log->employee_id == 0) {
            // Load customer and get name
            $log->load('customer');
            $log->action_person = $log->customer->name ?? '';
        } else {
            // Load employee and concatenate names
            $log->load('employee');
            $firstName = $log->employee->first_name ?? '';
            $middleName = $log->employee->middle_name ?? '';
            $lastName = $log->employee->last_name ?? '';
            
            // Concatenate names with proper spacing
            $names = array_filter([$firstName, $middleName, $lastName]);
            $log->action_person = implode(' ', $names);
        }
        
        return $log;
    }
    
} 