<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class SubcontractorEmployeeMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        if (!$request->user()) {
            return response()->json([
                'message' => 'Unauthorized',
                'statusCode' => 401
            ], 401);
        }

        // Get token scopes
        $scopes = $request->user()->token()->scopes;

        // Check if user is authenticated via subcontractor_employee guard
        if (in_array('subcontractor_employee', $scopes)) {
            $user = Auth::guard('subcontractor_employee')->user();
            
            if (!$user || !($user instanceof \App\Models\EmployeeSubcontractor)) {
                return response()->json([
                    'message' => 'Unauthorized: Invalid subcontractor employee user',
                    'statusCode' => 403
                ], 403);
            }

            // Set the authenticated user
            Auth::setUser($user);
            return $next($request);
        }

        // If not authenticated via subcontractor_employee scope, deny access
        return response()->json([
            'message' => 'Unauthorized: This endpoint requires subcontractor employee authentication',
            'statusCode' => 403
        ], 403);
    }
}
