<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class CustomerEmployeePermission extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'customer_permission_id',
        'status',
        'customer_id',
        'workspace_id',
        'module_id',
        'module_type',
        'tier_id',
        'del',
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];

    /**
     * Get the customer permission that owns this employee permission
     */
    public function customerPermission()
    {
        return $this->belongsTo(CustomerPermission::class, 'customer_permission_id', 'id');
    }

    /**
     * Get the module associated with this employee permission (when module_type is 'module')
     */
    public function module()
    {
        return $this->belongsTo(PermissionsModules::class, 'module_id', 'id');
    }

    /**
     * Get the sub-module associated with this employee permission (when module_type is 'sub_module')
     */
    public function subModule()
    {
        return $this->belongsTo(PermissionsSubModules::class, 'module_id', 'id');
    }

    /**
     * Get the module or sub-module based on module_type
     * Returns the appropriate relationship based on module_type field
     */
    public function getModuleOrSubModuleAttribute()
    {
        if ($this->module_type === 'sub_module') {
            return $this->subModule;
        }
        return $this->module;
    }

    /**
     * Get the customer that owns this permission
     */
    public function customer()
    {
        return $this->belongsTo(User::class, 'customer_id', 'id');
    }

    /**
     * Get the role associated with this permission
     */
    public function tier()
    {
        return $this->belongsTo(Tier::class, 'tier_id', 'id');
    }
}
